/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.block.entity.forge;

import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.block.entity.forge.SnailBoxInterfaceForge;
import dev.itsmeow.snailmail.menu.SnailBoxMenu;
import dev.itsmeow.snailmail.menu.forge.SnailBoxMenuForge;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SnailBoxBlockEntityImpl {
    private static final String ITEM_TAG_KEY = "item_handler";

    public static void loadStorage(SnailBoxBlockEntity blockEntity, CompoundTag compoundTag) {
        ((SnailBoxInterfaceForge)((Object)blockEntity)).deserializeHandlerNBT(compoundTag.m_128469_(ITEM_TAG_KEY));
    }

    public static void saveStorage(SnailBoxBlockEntity blockEntity, CompoundTag compoundTag) {
        compoundTag.m_128365_(ITEM_TAG_KEY, (Tag)((SnailBoxInterfaceForge)((Object)blockEntity)).serializeHandlerNBT());
    }

    public static void handleRemoved(SnailBoxBlockEntity blockEntity) {
        ((SnailBoxInterfaceForge)((Object)blockEntity)).handleRemoved();
    }

    public static SnailBoxMenu getClientMenu(int id, Inventory playerInventory, FriendlyByteBuf extra) {
        BlockPos pos = extra.m_130135_();
        if (extra.readableBytes() > 0) {
            String name = extra.m_130136_(35);
            boolean isOwner = extra.readBoolean();
            boolean isPublic = extra.readBoolean();
            int len = extra.readInt();
            HashSet<String> usernames = new HashSet<String>();
            for (int i = 0; i < len; ++i) {
                usernames.add(extra.m_130136_(35));
            }
            return new SnailBoxMenuForge(id, (Container)playerInventory, (IItemHandler)new ItemStackHandler(28), pos, name, isOwner, isPublic, usernames);
        }
        return new SnailBoxMenuForge(id, (Container)playerInventory, (IItemHandler)new ItemStackHandler(28), pos, "", false, false, new HashSet<String>());
    }

    public static MenuConstructor getServerMenuProvider(SnailBoxBlockEntity te) {
        return (id, playerInventory, serverPlayer) -> new SnailBoxMenuForge(id, (Container)playerInventory, te.m_58899_(), (IItemHandler)((SnailBoxInterfaceForge)((Object)te)).getItemHandler());
    }

    public static void dropItems(SnailBoxBlockEntity blockEntity) {
        for (int i = 0; i < ((SnailBoxInterfaceForge)((Object)blockEntity)).getItemHandler().getSlots(); ++i) {
            Containers.m_18992_((Level)blockEntity.m_58904_(), (double)blockEntity.m_58899_().m_123341_(), (double)blockEntity.m_58899_().m_123342_(), (double)blockEntity.m_58899_().m_123343_(), (ItemStack)((SnailBoxInterfaceForge)((Object)blockEntity)).getItemHandler().getStackInSlot(i));
        }
    }

    public static ItemStack getEnvelope(SnailBoxBlockEntity blockEntity) {
        return ((SnailBoxInterfaceForge)((Object)blockEntity)).getItemHandler().getStackInSlot(27);
    }

    public static void setEnvelope(SnailBoxBlockEntity blockEntity, ItemStack stack) {
        ((SnailBoxInterfaceForge)((Object)blockEntity)).getItemHandler().setStackInSlot(27, stack);
    }

    public static boolean setEnvelopeServer(SnailBoxBlockEntity blockEntity, ItemStack stack) {
        IItemHandler handlerRaw;
        LazyOptional hOpt = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (hOpt.isPresent() && (handlerRaw = (IItemHandler)hOpt.orElse(null)) instanceof ItemStackHandler) {
            ItemStackHandler handler = (ItemStackHandler)handlerRaw;
            handler.setStackInSlot(27, stack);
            return true;
        }
        return false;
    }

    public static boolean hasCapability(SnailBoxBlockEntity te) {
        return SnailBoxBlockEntityImpl.getCapability(te) != null;
    }

    private static ItemStackHandler getCapability(SnailBoxBlockEntity te) {
        LazyOptional hOpt = te.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (hOpt.isPresent() && hOpt.orElse(null) instanceof ItemStackHandler) {
            return (ItemStackHandler)hOpt.orElse(null);
        }
        return null;
    }

    public static boolean tryInsert(SnailBoxBlockEntity te, ItemStack newEnvelope) {
        int i;
        ItemStackHandler handler = SnailBoxBlockEntityImpl.getCapability(te);
        ItemStack result = newEnvelope;
        for (i = 0; i < 27 && !result.m_41619_(); ++i) {
            result = handler.insertItem(i, newEnvelope, true);
        }
        if (result.m_41619_()) {
            result = newEnvelope;
            for (i = 0; i < 27 && !result.m_41619_(); ++i) {
                result = handler.insertItem(i, newEnvelope, false);
            }
            return true;
        }
        return false;
    }
}

