/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.client;

import com.google.common.collect.ImmutableMap;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.itsmeow.snailmail.client.model.SnailManModel;
import dev.itsmeow.snailmail.client.screen.EnvelopeScreen;
import dev.itsmeow.snailmail.client.screen.SnailBoxScreen;
import dev.itsmeow.snailmail.entity.SnailManEntity;
import dev.itsmeow.snailmail.init.ModEntities;
import dev.itsmeow.snailmail.init.ModMenus;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;

public class SnailMailClient {
    public static final ResourceLocation TEXTURE = new ResourceLocation("snailmail", "textures/entity/snail_man.png");
    public static final ModelLayerLocation SNAILMAN_MODEL = new ModelLayerLocation(new ResourceLocation("snailmail", "snail_man"), "main");

    public static void clientInit() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModMenus.SNAIL_BOX.get()), SnailBoxScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModMenus.ENVELOPE.get()), EnvelopeScreen::new);
        if (Platform.isFabric()) {
            SnailMailClient.registerEntityRenders();
        }
    }

    public static void registerEntityRenders() {
        EntityRendererRegistry.register(() -> ModEntities.SNAIL_MAN.get(), ctx -> new MobRenderer<SnailManEntity, SnailManModel>(ctx, new SnailManModel(ctx.m_174023_(SNAILMAN_MODEL)), 0.0f){

            public ResourceLocation getTextureLocation(SnailManEntity entity) {
                return TEXTURE;
            }

            protected RenderType getRenderType(SnailManEntity livingEntity, boolean bl, boolean bl2, boolean bl3) {
                return RenderType.m_110454_((ResourceLocation)this.getTextureLocation(livingEntity), (boolean)true);
            }

            protected boolean shouldShowName(SnailManEntity mob) {
                return false;
            }
        });
    }

    public static void layerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> builder) {
        builder.put((Object)SNAILMAN_MODEL, (Object)SnailManModel.createBodyLayer());
    }
}

