/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.entity;

import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.util.Location;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SnailManEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Float> OPACITY = SynchedEntityData.m_135353_(SnailManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(SnailManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Location fromMailbox;
    private Location mailbox;
    private ItemStack transport;
    private boolean leavingDeliveryPoint = true;
    private boolean deliveryFailed = false;

    public SnailManEntity(EntityType<? extends SnailManEntity> type, Level level) {
        super(type, level);
        this.m_20331_(true);
        this.f_19794_ = true;
    }

    public SnailManEntity(EntityType<? extends SnailManEntity> type, Level level, Location destination, ItemStack transport, Location fromMailbox) {
        super(type, level);
        this.m_20331_(true);
        this.m_20242_(true);
        this.f_19794_ = true;
        this.fromMailbox = fromMailbox;
        this.mailbox = destination;
        this.transport = transport;
    }

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            opacity = 1.0f;
        } else if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        this.f_19804_.m_135381_(OPACITY, (Object)Float.valueOf(opacity));
    }

    public float getOpacity() {
        return ((Float)this.f_19804_.m_135370_(OPACITY)).floatValue();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OPACITY, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MoveAwayFromSpawnGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MoveToBoxGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ReturnFailedDelivery(this));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(((Float)this.f_19804_.m_135370_(YAW)).floatValue());
        this.f_20885_ = ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source != DamageSource.f_19317_;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("fromLocation") && compound.m_128441_("targetLocation") && compound.m_128441_("item") && compound.m_128441_("leaving") && compound.m_128441_("failed")) {
            this.fromMailbox = Location.read(compound.m_128469_("fromLocation"));
            this.mailbox = Location.read(compound.m_128469_("targetLocation"));
            this.transport = ItemStack.m_41712_((CompoundTag)compound.m_128469_("item"));
            this.leavingDeliveryPoint = compound.m_128471_("leaving");
            this.deliveryFailed = compound.m_128471_("failed");
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag tag1 = new CompoundTag();
        this.mailbox.write(tag1);
        compound.m_128365_("targetLocation", (Tag)tag1);
        CompoundTag tag2 = new CompoundTag();
        this.fromMailbox.write(tag2);
        compound.m_128365_("fromLocation", (Tag)tag2);
        CompoundTag tag = new CompoundTag();
        this.transport.m_41739_(tag);
        compound.m_128365_("item", (Tag)tag);
        compound.m_128379_("leaving", this.leavingDeliveryPoint);
        compound.m_128379_("failed", this.deliveryFailed);
    }

    private static void transportTo(SnailManEntity snail, BlockPos newPos, float yaw) {
        if (!snail.f_19853_.m_46472_().equals(snail.mailbox.getDimension())) {
            ServerLevel serverLevel = snail.m_20194_().m_129880_(snail.mailbox.getDimension());
            Entity entity = snail.m_6095_().m_20615_((Level)serverLevel);
            if (entity != null) {
                entity.m_20361_((Entity)snail);
                entity.m_20035_(newPos, yaw, entity.m_146909_());
                entity.m_20334_(0.0, 0.0, 0.0);
                serverLevel.m_143334_(entity);
            }
            snail.m_6089_();
            ((ServerLevel)snail.f_19853_).m_8886_();
            serverLevel.m_8886_();
        } else {
            snail.m_20334_(0.0, 0.0, 0.0);
            snail.m_20035_(newPos, yaw, snail.m_146909_());
        }
    }

    public static class MoveAwayFromSpawnGoal
    extends Goal {
        protected SnailManEntity snail;
        private Vec3 from;
        private int totalTicks = 0;
        private Vec3 dest;

        public MoveAwayFromSpawnGoal(SnailManEntity snail) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean m_8036_() {
            return this.snail.fromMailbox != null && this.snail.leavingDeliveryPoint;
        }

        public boolean m_8045_() {
            return this.snail.m_20182_().m_82554_(this.from) < 7.0 && this.snail.leavingDeliveryPoint && this.totalTicks < 160;
        }

        public void m_8041_() {
            this.totalTicks = 0;
            this.dest = null;
            this.snail.leavingDeliveryPoint = false;
            this.snail.m_20334_(0.0, 0.0, 0.0);
        }

        public void m_8056_() {
            this.from = this.snail.fromMailbox.asVec();
        }

        public void m_8037_() {
            Direction direction = this.getDirection();
            if (this.dest == null) {
                BlockPos away = this.getAwayPos(direction);
                this.dest = new Vec3((double)away.m_123341_() + 0.5, (double)away.m_123342_(), (double)away.m_123343_() + 0.5);
            }
            if (this.dest != null) {
                this.snail.f_19804_.m_135381_(YAW, (Object)Float.valueOf(direction.m_122435_()));
                this.snail.m_20256_(this.dest.m_82546_(this.snail.m_20182_()).m_82541_().m_82490_(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.m_20182_().m_82554_(this.from) - 1.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.f_19853_.m_46749_(this.snail.fromMailbox.toBP()) && (state = this.snail.f_19853_.m_8055_(this.snail.fromMailbox.toBP())) != null && state.m_60734_() == ModBlocks.SNAIL_BOX.get()) {
                dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.fromMailbox.toBP().m_5484_(dir, 7);
        }
    }

    public static class MoveToBoxGoal
    extends Goal {
        protected SnailManEntity snail;
        private Vec3 to;
        private int totalTicks = 0;
        private float angle = 0.0f;
        private boolean taskReset = false;

        public MoveToBoxGoal(SnailManEntity snail) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean m_8036_() {
            return this.snail.mailbox != null && !this.snail.leavingDeliveryPoint && !this.snail.deliveryFailed;
        }

        public boolean m_8045_() {
            if (this.taskReset) {
                return false;
            }
            return !this.snail.deliveryFailed && this.snail.m_20182_().m_82554_(this.to) > 1.0 || !this.snail.f_19853_.m_46472_().equals(this.snail.mailbox.getDimension());
        }

        public void m_8041_() {
            boolean isInvalid;
            this.totalTicks = 0;
            this.snail.m_20334_(0.0, 0.0, 0.0);
            BlockPos pos = this.snail.mailbox.toBP();
            ServerLevel world = this.snail.mailbox.getWorld(this.snail.m_20194_());
            BlockEntity teB = world.m_7702_(pos);
            boolean bl = isInvalid = world.m_8055_(pos).m_60734_() != ModBlocks.SNAIL_BOX.get() || teB == null || !(teB instanceof SnailBoxBlockEntity);
            if (isInvalid || !SnailMail.deliverTo((SnailBoxBlockEntity)teB, this.snail.transport, false)) {
                this.snail.deliveryFailed = true;
                SnailMail.forceArea(this.snail.fromMailbox.getWorld(this.snail.m_20194_()), this.snail.fromMailbox.toBP(), true);
                if (isInvalid) {
                    SnailMail.SnailBoxSavedData.getOrCreate(this.snail.f_19853_).removeBoxRaw(this.snail.mailbox);
                }
            } else {
                this.snail.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.snail.deliveryFailed || !this.snail.fromMailbox.equals(this.snail.mailbox)) {
                SnailMail.forceArea(world, pos, false);
            }
        }

        public void m_8056_() {
            BlockPos newPos;
            this.to = this.snail.mailbox.asVec();
            this.angle = this.getDirection().m_122424_().m_122435_();
            BlockPos away = this.getAwayPos(this.getDirection());
            ServerLevel destWorld = this.snail.mailbox.getWorld(this.snail.m_20194_());
            BlockPos blockPos = newPos = destWorld != null && destWorld.m_46749_(away) ? away : this.snail.mailbox.toBP();
            if (destWorld != null && destWorld.m_7232_(newPos.m_123341_() >> 4, newPos.m_123343_() >> 4) && destWorld.m_143340_(newPos)) {
                SnailManEntity.transportTo(this.snail, newPos, this.angle);
            } else {
                this.taskReset = true;
            }
        }

        public void m_8037_() {
            if (this.totalTicks > 160) {
                this.snail.m_20035_(this.snail.mailbox.toBP().m_7494_(), this.angle, this.snail.m_146909_());
                this.snail.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.snail.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.angle));
                this.snail.m_20256_(this.to.m_82546_(this.snail.m_20182_()).m_82541_().m_82490_(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.m_20182_().m_82554_(this.to) - 3.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.f_19853_.m_46749_(this.snail.mailbox.toBP()) && (state = this.snail.f_19853_.m_8055_(this.snail.mailbox.toBP())) != null && state.m_60734_() == ModBlocks.SNAIL_BOX.get()) {
                dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.mailbox.toBP().m_5484_(dir, 7);
        }
    }

    public static class ReturnFailedDelivery
    extends Goal {
        protected SnailManEntity snail;
        private Vec3 to;
        private int totalTicks = 0;
        private float angle = 0.0f;
        private boolean taskReset = false;

        public ReturnFailedDelivery(SnailManEntity snail) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean m_8036_() {
            return this.snail.fromMailbox != null && this.snail.deliveryFailed;
        }

        public boolean m_8045_() {
            return !this.taskReset && this.snail.m_20182_().m_82554_(this.to) > 1.0 || !this.snail.f_19853_.m_46472_().equals(this.snail.fromMailbox.getDimension());
        }

        public void m_8041_() {
            boolean isInvalid;
            this.totalTicks = 0;
            this.snail.m_20334_(0.0, 0.0, 0.0);
            BlockPos pos = this.snail.fromMailbox.toBP();
            BlockEntity teB = this.snail.f_19853_.m_7702_(pos);
            boolean bl = isInvalid = this.snail.f_19853_.m_8055_(pos).m_60734_() != ModBlocks.SNAIL_BOX.get() || teB == null || !(teB instanceof SnailBoxBlockEntity);
            if (isInvalid || !SnailMail.deliverTo((SnailBoxBlockEntity)teB, this.snail.transport, true)) {
                if (isInvalid) {
                    SnailMail.SnailBoxSavedData.getOrCreate(this.snail.f_19853_).removeBoxRaw(this.snail.fromMailbox);
                }
                ItemStack stack = this.snail.transport;
                Optional<ItemStack> iOpt = EnvelopeItem.convert(this.snail.transport);
                if (iOpt.isPresent()) {
                    stack = iOpt.get();
                    if (!stack.m_41782_()) {
                        stack.m_41751_(new CompoundTag());
                    }
                    stack.m_41783_().m_128379_("delivery_failed", true);
                }
                this.snail.m_19983_(stack);
            }
            SnailMail.forceArea(this.snail.fromMailbox.getWorld(this.snail.m_20194_()), pos, false);
            this.snail.m_142687_(Entity.RemovalReason.DISCARDED);
        }

        public void m_8056_() {
            BlockPos newPos;
            this.to = this.snail.fromMailbox.asVec();
            this.angle = this.getDirection().m_122424_().m_122435_();
            BlockPos away = this.getAwayPos(this.getDirection());
            ServerLevel destWorld = this.snail.fromMailbox.getWorld(this.snail.m_20194_());
            BlockPos blockPos = newPos = destWorld.m_46749_(away) ? away : this.snail.fromMailbox.toBP();
            if (destWorld.m_7232_(newPos.m_123341_() >> 4, newPos.m_123343_() >> 4) && destWorld.m_143340_(newPos)) {
                SnailManEntity.transportTo(this.snail, newPos, this.angle);
            } else {
                this.taskReset = true;
            }
        }

        public void m_8037_() {
            if (this.totalTicks > 160) {
                this.snail.m_20035_(this.snail.fromMailbox.toBP().m_7494_(), this.angle, this.snail.m_146909_());
                this.snail.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.snail.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.angle));
                this.snail.m_20256_(this.to.m_82546_(this.snail.m_20182_()).m_82541_().m_82490_(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.m_20182_().m_82554_(this.to) - 3.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.f_19853_.m_46749_(this.snail.fromMailbox.toBP()) && (state = this.snail.f_19853_.m_8055_(this.snail.fromMailbox.toBP())) != null && state.m_60734_() == ModBlocks.SNAIL_BOX.get()) {
                dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.fromMailbox.toBP().m_5484_(dir, 7);
        }
    }
}

