/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.menu.MenuRegistry;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.forge.EnvelopeItemImpl;
import dev.itsmeow.snailmail.menu.EnvelopeMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnvelopeItem
extends Item {
    private final boolean isOpen;
    private static final Component title = Component.m_237115_((String)"container.snailmail.envelope");
    public static final int SLOT_COUNT = 28;

    public EnvelopeItem(boolean isOpen) {
        super(new Item.Properties().m_41491_(SnailMail.ITEM_GROUP).m_41487_(1));
        this.isOpen = isOpen;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_().m_128425_("AddressedTo", 8) && !stack.m_41783_().m_128461_("AddressedTo").isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.snailmail.to", (Object[])new Object[]{Component.m_237113_((String)stack.m_41783_().m_128461_("AddressedTo")).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY))}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128425_("AddressedFrom", 8) && !stack.m_41783_().m_128461_("AddressedFrom").isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.snailmail.from", (Object[])new Object[]{Component.m_237113_((String)stack.m_41783_().m_128461_("AddressedFrom")).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY))}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED).m_131155_(Boolean.valueOf(true))));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128425_("delivery_failed", 1) && stack.m_41783_().m_128471_("delivery_failed")) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.snailmail.delivery_failed").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))));
        }
        if (stack.m_41720_() == ModItems.ENVELOPE_OPEN.get() && EnvelopeItem.isStamped(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.snailmail.stamped").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(true))));
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isStamped(ItemStack stack) {
        return EnvelopeItemImpl.isStamped(stack);
    }

    public static String getString(ItemStack stack, String key) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128461_(key);
        }
        return "";
    }

    public static void putStringChecked(ItemStack stack, String key, String value) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128359_(key, value);
    }

    public static Optional<ItemStack> convert(ItemStack stack) {
        boolean fromOpen;
        boolean bl = fromOpen = stack.m_41720_() == ModItems.ENVELOPE_OPEN.get();
        if (fromOpen || stack.m_41720_() == ModItems.ENVELOPE_CLOSED.get()) {
            return EnvelopeItem.doConvert(stack, fromOpen);
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<ItemStack> doConvert(ItemStack stack, boolean fromOpen) {
        void var1_1;
        return EnvelopeItemImpl.doConvert(stack, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void emptyEnvelope(ItemStack stack, Player playerIn) {
        void var1_1;
        EnvelopeItemImpl.emptyEnvelope(stack, (Player)var1_1);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        Optional<ItemStack> open;
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!stack.m_41619_() && EnvelopeItem.hasItems(stack) && playerIn instanceof ServerPlayer && stack.m_41720_() == ModItems.ENVELOPE_CLOSED.get() && (open = EnvelopeItem.convert(stack)).isPresent()) {
            EnvelopeItem.emptyEnvelope(stack, playerIn);
            return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)ModItems.ENVELOPE_OPEN.get()));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasItems(ItemStack stack) {
        return EnvelopeItemImpl.hasItems(stack);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvelopeMenu getClientMenu(int id, Inventory playerInventory, FriendlyByteBuf extra) {
        void var2_2;
        void var1_1;
        return EnvelopeItemImpl.getClientMenu(id, (Inventory)var1_1, (FriendlyByteBuf)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MenuConstructor getServerMenuProvider(ItemStack stack) {
        return EnvelopeItemImpl.getServerMenuProvider(stack);
    }

    public static void openGUI(ServerPlayer player, ItemStack stack, BlockPos pos) {
        MenuConstructor provider = EnvelopeItem.getServerMenuProvider(stack);
        SimpleMenuProvider namedProvider = new SimpleMenuProvider(provider, title);
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)namedProvider, buf -> {
            buf.m_130064_(pos);
            if (stack.m_41782_()) {
                if (stack.m_41783_().m_128425_("AddressedTo", 8)) {
                    buf.m_130072_(stack.m_41783_().m_128461_("AddressedTo"), 35);
                }
                if (stack.m_41783_().m_128425_("AddressedFrom", 8)) {
                    buf.m_130072_(stack.m_41783_().m_128461_("AddressedFrom"), 35);
                }
            }
        });
    }
}

