/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.item.forge;

import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.menu.EnvelopeMenu;
import dev.itsmeow.snailmail.menu.forge.EnvelopeMenuForge;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EnvelopeItemImpl {
    public static boolean isStamped(ItemStack stack) {
        ItemStack stampSlot;
        LazyOptional cap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        return cap.isPresent() && !(stampSlot = ((IItemHandler)cap.orElse(null)).getStackInSlot(27)).m_41619_() && stampSlot.m_41720_() == ModItems.STAMP.get();
    }

    public static Optional<ItemStack> doConvert(ItemStack stack, boolean fromOpen) {
        LazyOptional hOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (hOpt.isPresent()) {
            IItemHandler newHandler;
            IItemHandler handler = (IItemHandler)hOpt.orElse(null);
            ItemStack newStack = new ItemStack(fromOpen ? (ItemLike)ModItems.ENVELOPE_CLOSED.get() : (ItemLike)ModItems.ENVELOPE_OPEN.get());
            LazyOptional nHOpt = newStack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (nHOpt.isPresent() && (newHandler = (IItemHandler)nHOpt.orElse(null)) instanceof ItemStackHandler) {
                ItemStackHandler newH = (ItemStackHandler)newHandler;
                for (int i = 0; i < Math.min(newH.getSlots(), handler.getSlots()); ++i) {
                    newH.setStackInSlot(i, handler.getStackInSlot(i));
                }
                EnvelopeItemImpl.copyTagString(stack, newStack, "AddressedTo");
                EnvelopeItemImpl.copyTagString(stack, newStack, "AddressedFrom");
                return Optional.of(newStack);
            }
        }
        return Optional.empty();
    }

    protected static void copyTagString(ItemStack original, ItemStack newStack, String key) {
        if (original.m_41782_() && original.m_41783_().m_128425_(key, 8)) {
            EnvelopeItem.putStringChecked(newStack, key, original.m_41783_().m_128461_(key));
        }
    }

    public static boolean hasItems(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ITEM_HANDLER) != null;
    }

    public static EnvelopeMenu getClientMenu(int id, Inventory playerInventory, FriendlyByteBuf extra) {
        if (extra.readableBytes() > 0) {
            try {
                BlockPos returnPos = extra.m_130135_();
                String toName = "";
                if (extra.readableBytes() > 0) {
                    toName = extra.m_130136_(35);
                }
                String fromName = "";
                if (extra.readableBytes() > 0) {
                    fromName = extra.m_130136_(35);
                }
                return new EnvelopeMenuForge(id, (Container)playerInventory, (IItemHandler)new ItemStackHandler(28), returnPos, toName, fromName);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return new EnvelopeMenuForge(id, (Container)playerInventory, (IItemHandler)new ItemStackHandler(28));
    }

    public static MenuConstructor getServerMenuProvider(ItemStack stack) {
        return (id, playerInventory, serverPlayer) -> new EnvelopeMenuForge(id, (Container)playerInventory, (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null));
    }

    public static void emptyEnvelope(ItemStack stack, Player playerIn) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)inv.getStackInSlot(i));
            }
        });
    }
}

