/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.IEnvelopePacketReceiver;
import dev.itsmeow.snailmail.entity.SnailManEntity;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModEntities;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.init.ModNetwork;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.menu.SnailBoxMenu;
import dev.itsmeow.snailmail.network.OpenSnailBoxGUIPacket;
import dev.itsmeow.snailmail.util.BoxData;
import dev.itsmeow.snailmail.util.Location;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SendEnvelopePacket {
    public Type type;
    public BoxData[] boxes;

    public SendEnvelopePacket(Type type) {
        this.type = type;
    }

    public SendEnvelopePacket(Type type, BoxData ... boxes) {
        this.type = type;
        this.boxes = boxes;
    }

    public static void encode(SendEnvelopePacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.type.ordinal());
        if (pkt.boxes != null) {
            buf.writeInt(pkt.boxes.length);
            for (BoxData box : pkt.boxes) {
                box.write(buf);
            }
        }
    }

    public static SendEnvelopePacket decode(FriendlyByteBuf buf) {
        Type type = Type.values()[buf.readInt()];
        BoxData[] boxL = null;
        if (buf.readableBytes() > 0) {
            int len = buf.readInt();
            boxL = new BoxData[len];
            for (int i = 0; i < len; ++i) {
                boxL[i] = BoxData.read(buf);
            }
        }
        return new SendEnvelopePacket(type, boxL);
    }

    public static boolean deliver(SnailBoxBlockEntity fromTe, ItemStack stack, Location location, Location from, ServerPlayer player) {
        stack = stack.m_41777_();
        if (!SnailBoxBlockEntity.setEnvelopeServer(fromTe, ItemStack.f_41583_)) {
            return false;
        }
        ServerLevel fromW = from.getWorld(player.m_20194_());
        try {
            SnailManEntity snail = new SnailManEntity((EntityType<? extends SnailManEntity>)((EntityType)ModEntities.SNAIL_MAN.get()), (Level)fromW, location, stack, from);
            snail.m_6518_((ServerLevelAccessor)fromW, fromW.m_6436_(from.toBP()), MobSpawnType.MOB_SUMMONED, null, null);
            BlockPos pos = from.toBP().m_121945_((Direction)fromTe.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
            snail.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            fromW.m_7967_((Entity)snail);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static enum Type {
        TO_SERVER,
        NO_ENVELOPE,
        NO_STAMP,
        NO_ADDRESS,
        INVALID_ADDRESS,
        NO_BOXES,
        SELECT_BOX,
        SUCCESS,
        BOX_NO_EXIST,
        WAIT,
        REOPEN;

    }

    public static class Handler {
        public static void handle(SendEnvelopePacket msg, Supplier<NetworkManager.PacketContext> ctx) {
            if (ctx.get().getEnvironment() == Env.SERVER && msg.type == Type.TO_SERVER) {
                ctx.get().queue(() -> {
                    ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer();
                    if (sender.f_36096_ instanceof SnailBoxMenu) {
                        ItemStack stack = sender.f_36096_.m_38853_(27).m_7993_();
                        if (!stack.m_41619_() && stack.m_41720_() == ModItems.ENVELOPE_OPEN.get()) {
                            if (EnvelopeItem.isStamped(stack)) {
                                String to = EnvelopeItem.getString(stack, "AddressedTo");
                                if (!to.isEmpty()) {
                                    Handler.reply(ctx, Type.WAIT);
                                    new Thread(() -> Handler.lambda$handle$6(sender, to, (Supplier)ctx, msg, stack)).start();
                                } else {
                                    Handler.reply(ctx, Type.NO_ADDRESS);
                                }
                            } else {
                                Handler.reply(ctx, Type.NO_STAMP);
                            }
                        } else {
                            Handler.reply(ctx, Type.NO_ENVELOPE);
                        }
                    } else {
                        Handler.reply(ctx, Type.REOPEN);
                    }
                });
            }
            if (ctx.get().getEnvironment() == Env.CLIENT && msg.type != Type.TO_SERVER) {
                ctx.get().queue(() -> {
                    if (msg.type == Type.REOPEN && Minecraft.m_91087_().f_91074_.f_36096_ instanceof SnailBoxMenu) {
                        ModNetwork.HANDLER.sendToServer((Object)new OpenSnailBoxGUIPacket(((SnailBoxMenu)Minecraft.m_91087_().f_91074_.f_36096_).pos));
                    } else if (Minecraft.m_91087_().f_91080_ instanceof IEnvelopePacketReceiver) {
                        ((IEnvelopePacketReceiver)Minecraft.m_91087_().f_91080_).receivePacket(msg);
                    }
                });
            }
        }

        private static void reply(Supplier<NetworkManager.PacketContext> ctx, Type response) {
            ModNetwork.HANDLER.sendToPlayer((ServerPlayer)ctx.get().getPlayer(), (Object)new SendEnvelopePacket(response));
        }

        private static void reply(Supplier<NetworkManager.PacketContext> ctx, Type response, BoxData ... boxData) {
            ModNetwork.HANDLER.sendToPlayer((ServerPlayer)ctx.get().getPlayer(), (Object)new SendEnvelopePacket(response, boxData));
        }

        private static /* synthetic */ void lambda$handle$6(ServerPlayer sender, String to, Supplier ctx, SendEnvelopePacket msg, ItemStack stack) {
            Optional prof = sender.m_20194_().m_129927_().m_10996_(to);
            ((NetworkManager.PacketContext)ctx.get()).queue(() -> Handler.lambda$handle$5(prof, sender, msg, (Supplier)ctx, stack));
        }

        private static /* synthetic */ void lambda$handle$5(Optional prof, ServerPlayer sender, SendEnvelopePacket msg, Supplier ctx, ItemStack stack) {
            if (prof.isPresent() && ((GameProfile)prof.get()).getId() != null) {
                UUID uuid = ((GameProfile)prof.get()).getId();
                SnailMail.SnailBoxSavedData data = SnailMail.SnailBoxSavedData.getOrCreate((Level)sender.m_9236_());
                Set<Location> boxPos = data.getBoxes(uuid);
                HashSet<BoxData> boxes = new HashSet<BoxData>();
                for (Location location : boxPos) {
                    boxes.add(new BoxData(data.getNameForPos(location), location, data.isPublic(location), false));
                }
                Set<Location> boxPosMember = data.getMemberBoxes(uuid);
                for (Location pos : boxPosMember) {
                    boxes.add(new BoxData(data.getNameForPos(pos), pos, data.isPublic(pos), true));
                }
                if (boxes.size() > 0) {
                    if (msg.boxes == null) {
                        List<BoxData> list = boxes.stream().sorted((element1, element2) -> element1.name.length() > element2.name.length() ? 1 : (element1.name.length() < element2.name.length() ? -1 : element1.name.compareTo(element2.name))).collect(Collectors.toList());
                        Handler.reply(ctx, Type.SELECT_BOX, list.toArray(new BoxData[0]));
                    } else if (msg.boxes.length == 1) {
                        int n = msg.boxes[0].posHash;
                        HashSet<Location> hashes = new HashSet<Location>(boxPos);
                        hashes.removeIf(p -> p.hashCode() != hashWanted);
                        Location selected = null;
                        if (hashes.size() == 1) {
                            selected = hashes.toArray(new Location[1])[0];
                        } else {
                            HashSet<Location> hashesM = new HashSet<Location>(boxPosMember);
                            hashesM.removeIf(p -> p.hashCode() != hashWanted);
                            if (hashesM.size() == 1) {
                                selected = hashesM.toArray(new Location[1])[0];
                            }
                        }
                        if (selected != null) {
                            SnailBoxBlockEntity fromTe = ((SnailBoxMenu)sender.f_36096_).getTile((Player)sender);
                            Location selectFinal = selected;
                            ServerLevel world = selectFinal.getWorld(sender.m_20194_());
                            BlockPos pos = selectFinal.toBP();
                            Handler.reply(ctx, Type.WAIT);
                            new Thread(() -> Handler.lambda$handle$4(world, pos, (Supplier)ctx, fromTe, stack, selectFinal, sender)).start();
                        }
                    }
                } else {
                    Handler.reply(ctx, Type.NO_BOXES);
                }
            } else {
                Handler.reply(ctx, Type.INVALID_ADDRESS);
            }
        }

        private static /* synthetic */ void lambda$handle$4(ServerLevel world, BlockPos pos, Supplier ctx, SnailBoxBlockEntity fromTe, ItemStack stack, Location selectFinal, ServerPlayer sender) {
            SnailMail.forceArea(world, pos, true);
            ((NetworkManager.PacketContext)ctx.get()).queue(() -> Handler.lambda$handle$3(world, pos, fromTe, stack, selectFinal, sender, (Supplier)ctx));
        }

        private static /* synthetic */ void lambda$handle$3(ServerLevel world, BlockPos pos, SnailBoxBlockEntity fromTe, ItemStack stack, Location selectFinal, ServerPlayer sender, Supplier ctx) {
            if (world.m_46749_(pos)) {
                BlockEntity teB = world.m_7702_(pos);
                if (world.m_8055_(pos).m_60734_() == ModBlocks.SNAIL_BOX.get() && teB != null && teB instanceof SnailBoxBlockEntity) {
                    SendEnvelopePacket.deliver(fromTe, stack, selectFinal, fromTe.getLocation(), sender);
                    Handler.reply(ctx, Type.SUCCESS);
                } else {
                    Handler.reply(ctx, Type.BOX_NO_EXIST);
                    SnailMail.SnailBoxSavedData.getOrCreate((Level)sender.m_9236_()).removeBoxRaw(selectFinal);
                }
            }
        }
    }
}

