/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Location {
    public static final Location ZERO = new Location((ResourceKey<Level>)Level.f_46428_, 0, 0, 0);
    private final ResourceKey<Level> dimension;
    private final int x;
    private final int y;
    private final int z;

    public Location(Level world, BlockPos pos) {
        this((ResourceKey<Level>)world.m_46472_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Location(Level world, int x, int y, int z) {
        this((ResourceKey<Level>)world.m_46472_(), x, y, z);
    }

    public Location(ResourceKey<Level> dimension, BlockPos pos) {
        this(dimension, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Location(ResourceKey<Level> dimension, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos toBP() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130072_(this.dimension.m_135782_().toString(), 60);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static Location read(FriendlyByteBuf buf) {
        return new Location((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(60))), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128359_("dim", this.dimension.m_135782_().toString());
        tag.m_128405_("x", this.x);
        tag.m_128405_("y", this.y);
        tag.m_128405_("z", this.z);
        return tag;
    }

    public static Location read(CompoundTag tag) {
        return new Location((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim"))), tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public ServerLevel getWorld(MinecraftServer server) {
        return server.m_129880_(this.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.dimension.m_135782_().toString(), this.x, this.y, this.z);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location otherL = (Location)other;
        if (this.getX() != otherL.getX()) {
            return false;
        }
        if (this.getY() != otherL.getY()) {
            return false;
        }
        if (this.getZ() != otherL.getZ()) {
            return false;
        }
        return this.getDimension() == otherL.getDimension();
    }

    public Vec3 asVec() {
        return new Vec3((double)this.x + 0.5, (double)this.y, (double)this.z + 0.5);
    }
}

