/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.util.forge;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SnailMailCommonConfigImpl {
    public static boolean lockBoxes() {
        return (Boolean)Configuration.get().LOCK_BOXES.get();
    }

    public static boolean protectBoxDestroy() {
        return (Boolean)Configuration.get().PROTECT_BOX_DESTROY.get();
    }

    public static boolean opBypassLock() {
        return (Boolean)Configuration.get().OP_BYPASS_LOCK.get();
    }

    public static int bypassLockOpLevel() {
        return (Integer)Configuration.get().BYPASS_LOCK_OP_LEVEL.get();
    }

    public static class Configuration {
        public static ForgeConfigSpec SPEC = null;
        protected static Configuration INSTANCE = null;
        public final ForgeConfigSpec.BooleanValue LOCK_BOXES;
        public final ForgeConfigSpec.BooleanValue PROTECT_BOX_DESTROY;
        public final ForgeConfigSpec.BooleanValue OP_BYPASS_LOCK;
        public final ForgeConfigSpec.IntValue BYPASS_LOCK_OP_LEVEL;

        public static Configuration get() {
            return INSTANCE;
        }

        public static ForgeConfigSpec initSpec() {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Configuration)specPair.getLeft();
            return (ForgeConfigSpec)specPair.getRight();
        }

        protected Configuration(ForgeConfigSpec.Builder builder) {
            this.LOCK_BOXES = builder.comment("Block snailboxes from being opened by non-owners").define("lock_boxes", true);
            this.PROTECT_BOX_DESTROY = builder.comment("Protect snailboxes from being destroyed by non-owners").define("protect_box_destroy", true);
            this.OP_BYPASS_LOCK = builder.comment("If the op level defined in bypass_lock_op_level can bypass locked boxes").define("op_bypass_lock", true);
            this.BYPASS_LOCK_OP_LEVEL = builder.comment("Op level to bypass snailbox locks").defineInRange("bypass_lock_op_level", 3, 1, 4);
        }
    }
}

