/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.vendored.joml.Vector2f;

public class Vector2Uniform
extends Uniform {
    private Vector2f cachedValue = null;
    private final Supplier<Vector2f> value;

    Vector2Uniform(int location, Supplier<Vector2f> value) {
        super(location);
        this.value = value;
    }

    Vector2Uniform(int location, Supplier<Vector2f> value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector2f newValue = this.value.get();
        if (this.cachedValue == null || !newValue.equals(this.cachedValue)) {
            this.cachedValue = newValue;
            IrisRenderSystem.uniform2f(this.location, newValue.x, newValue.y);
        }
    }
}

