/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Position;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.Siding;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class SidingSchema
extends SavedRailBase<Siding, Depot> {
    protected final double railLength;
    protected final ObjectArrayList<VehicleCar> vehicleCars = new ObjectArrayList();
    protected long maxVehicles;
    protected long delayedVehicleSpeedIncreasePercentage = 25L;
    protected long delayedVehicleReduceDwellTimePercentage = 100L;
    protected double maxManualSpeed;
    protected long manualToAutomaticTime = 10000L;
    protected double acceleration = 4.0E-6;
    protected double deceleration = 4.0E-6;

    protected SidingSchema(double railLength, Position position1, Position position2, TransportMode transportMode, Data data) {
        super(position1, position2, transportMode, data);
        this.railLength = railLength;
    }

    protected SidingSchema(ReaderBase readerBase, Data data) {
        super(readerBase, data);
        this.railLength = readerBase.getDouble("railLength", 0.0);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        super.updateData(readerBase);
        readerBase.iterateReaderArray("vehicleCars", this.vehicleCars::clear, readerBaseChild -> this.vehicleCars.add(new VehicleCar((ReaderBase)readerBaseChild)));
        readerBase.unpackLong("maxVehicles", value -> {
            this.maxVehicles = value;
        });
        readerBase.unpackLong("delayedVehicleSpeedIncreasePercentage", value -> {
            this.delayedVehicleSpeedIncreasePercentage = value;
        });
        readerBase.unpackLong("delayedVehicleReduceDwellTimePercentage", value -> {
            this.delayedVehicleReduceDwellTimePercentage = value;
        });
        readerBase.unpackDouble("maxManualSpeed", value -> {
            this.maxManualSpeed = value;
        });
        readerBase.unpackLong("manualToAutomaticTime", value -> {
            this.manualToAutomaticTime = value;
        });
        readerBase.unpackDouble("acceleration", value -> {
            this.acceleration = value;
        });
        readerBase.unpackDouble("deceleration", value -> {
            this.deceleration = value;
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        super.serializeData(writerBase);
        writerBase.writeDouble("railLength", this.railLength);
        this.serializeVehicleCars(writerBase);
        this.serializeMaxVehicles(writerBase);
        this.serializeDelayedVehicleSpeedIncreasePercentage(writerBase);
        this.serializeDelayedVehicleReduceDwellTimePercentage(writerBase);
        this.serializeMaxManualSpeed(writerBase);
        this.serializeManualToAutomaticTime(writerBase);
        this.serializeAcceleration(writerBase);
        this.serializeDeceleration(writerBase);
    }

    @Override
    @Nonnull
    public String toString() {
        return super.toString() + "railLength: " + this.railLength + "\nvehicleCars: " + this.vehicleCars + "\nmaxVehicles: " + this.maxVehicles + "\ndelayedVehicleSpeedIncreasePercentage: " + this.delayedVehicleSpeedIncreasePercentage + "\ndelayedVehicleReduceDwellTimePercentage: " + this.delayedVehicleReduceDwellTimePercentage + "\nmaxManualSpeed: " + this.maxManualSpeed + "\nmanualToAutomaticTime: " + this.manualToAutomaticTime + "\nacceleration: " + this.acceleration + "\ndeceleration: " + this.deceleration + "\n";
    }

    protected void serializeVehicleCars(WriterBase writerBase) {
        writerBase.writeDataset(this.vehicleCars, "vehicleCars");
    }

    protected void serializeMaxVehicles(WriterBase writerBase) {
        writerBase.writeLong("maxVehicles", this.maxVehicles);
    }

    protected void serializeDelayedVehicleSpeedIncreasePercentage(WriterBase writerBase) {
        writerBase.writeLong("delayedVehicleSpeedIncreasePercentage", this.delayedVehicleSpeedIncreasePercentage);
    }

    protected void serializeDelayedVehicleReduceDwellTimePercentage(WriterBase writerBase) {
        writerBase.writeLong("delayedVehicleReduceDwellTimePercentage", this.delayedVehicleReduceDwellTimePercentage);
    }

    protected void serializeMaxManualSpeed(WriterBase writerBase) {
        writerBase.writeDouble("maxManualSpeed", this.maxManualSpeed);
    }

    protected void serializeManualToAutomaticTime(WriterBase writerBase) {
        writerBase.writeLong("manualToAutomaticTime", this.manualToAutomaticTime);
    }

    protected void serializeAcceleration(WriterBase writerBase) {
        writerBase.writeDouble("acceleration", this.acceleration);
    }

    protected void serializeDeceleration(WriterBase writerBase) {
        writerBase.writeDouble("deceleration", this.deceleration);
    }
}

