/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.integration;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.mtr.core.generated.integration.ResponseSchema;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;

public final class Response
extends ResponseSchema {
    public final JsonObject data;

    public Response(int code, long currentTime, String text, @Nullable JsonObject data) {
        super(code, currentTime, text, 1L);
        this.data = data;
    }

    private Response(ReaderBase readerBase, JsonObject jsonObject) {
        super(readerBase);
        this.updateData(readerBase);
        this.data = jsonObject.getAsJsonObject("data");
    }

    public JsonObject getJson() {
        JsonObject jsonObject = Utilities.getJsonObjectFromData(this);
        if (this.data != null) {
            jsonObject.add("data", this.data);
        }
        return jsonObject;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public <T extends SerializedDataBase> T getData(Function<JsonReader, T> dataInstance) {
        return (T)((SerializedDataBase)dataInstance.apply(new JsonReader(this.data)));
    }

    public static Response create(JsonObject jsonObject) {
        JsonReader jsonReader = new JsonReader(jsonObject);
        return new Response(jsonReader, jsonObject);
    }
}

