/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.operation;

import java.util.function.Consumer;
import org.mtr.core.Main;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.Position;
import org.mtr.core.data.Station;
import org.mtr.core.generated.operation.DirectionsRequestSchema;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.simulation.Simulator;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class DirectionsRequest
extends DirectionsRequestSchema {
    public DirectionsRequest(Position startPosition, Position endPosition) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public DirectionsRequest(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    @Override
    protected Position getDefaultStartPosition() {
        return new Position(0L, 0L, 0L);
    }

    @Override
    protected Position getDefaultEndPosition() {
        return new Position(0L, 0L, 0L);
    }

    public JsonObject find(Simulator simulator, Consumer<JsonObject> sendResponse) {
        String startStationName = DirectionsRequest.findStationName(simulator, this.startStation, position -> {
            this.startPosition = position;
        });
        String endStationName = DirectionsRequest.findStationName(simulator, this.endStation, position -> {
            this.endPosition = position;
        });
        Main.LOGGER.info("Finding directions between ({}, {}, {}){} and ({}, {}, {}){}", (Object)this.startPosition.getX(), (Object)this.startPosition.getY(), (Object)this.startPosition.getZ(), (Object)startStationName, (Object)this.endPosition.getX(), (Object)this.endPosition.getY(), (Object)this.endPosition.getZ(), (Object)endStationName);
        simulator.addDirectionsPathFinder(this.startPosition, this.endPosition, this.maxWalkingDistance, sendResponse);
        return new JsonObject();
    }

    private static String findStationName(Simulator simulator, String stationName, Consumer<Position> callback) {
        ObjectArrayList stations;
        if (!stationName.isEmpty() && !(stations = NameColorDataBase.getDataByName(simulator.stations, stationName)).isEmpty()) {
            Station station = (Station)stations.get(0);
            callback.accept(station.getCenter());
            return String.format(" (%s)", station.getName());
        }
        return "";
    }
}

