/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.operation;

import java.util.function.Consumer;
import org.mtr.core.data.Depot;
import org.mtr.core.generated.operation.GenerateOrClearByDepotIdsSchema;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.simulation.Simulator;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class GenerateOrClearByDepotIds
extends GenerateOrClearByDepotIdsSchema {
    public GenerateOrClearByDepotIds() {
    }

    public GenerateOrClearByDepotIds(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public void addDepotId(long depotId) {
        this.depotIds.add(depotId);
    }

    public JsonObject generate(Simulator simulator, Consumer<JsonObject> sendResponse) {
        Depot.generateDepots(simulator, this.getDepots(simulator), sendResponse);
        return new JsonObject();
    }

    public JsonObject clear(Simulator simulator) {
        Depot.clearDepots(this.getDepots(simulator));
        return new JsonObject();
    }

    private ObjectArrayList<Depot> getDepots(Simulator simulator) {
        ObjectArrayList<Depot> depots = new ObjectArrayList<Depot>();
        this.depotIds.forEach(depotId -> {
            Depot depot = (Depot)simulator.depotIdMap.get(depotId);
            if (depot != null) {
                depots.add(depot);
            }
        });
        return depots;
    }
}

