/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.path;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Position;
import org.mtr.core.data.Route;
import org.mtr.core.operation.DirectionsResponse;
import org.mtr.core.path.PathFinder;
import org.mtr.core.simulation.Simulator;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2LongAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class DirectionsPathFinder
extends PathFinder<PositionAndPlatform> {
    private final Simulator simulator;
    private final long startMillis;
    private final long maxWalkingDistance;
    private final Consumer<JsonObject> sendResponse;
    private static final int WALKING_MULTIPLIER = 1000;

    public DirectionsPathFinder(Simulator simulator, Position startPosition, Position endPosition, long maxWalkingDistance, Consumer<JsonObject> sendResponse) {
        super(new PositionAndPlatform(startPosition, 0L), new PositionAndPlatform(endPosition, 0L));
        this.simulator = simulator;
        this.startMillis = System.currentTimeMillis();
        this.maxWalkingDistance = maxWalkingDistance;
        this.sendResponse = sendResponse;
    }

    @Override
    protected ObjectArrayList<PathFinder.ConnectionDetails<PositionAndPlatform>> getConnections(long elapsedTime, PositionAndPlatform data, @Nullable Long previousRouteId) {
        Platform platform;
        ObjectArrayList<PathFinder.ConnectionDetails<PositionAndPlatform>> connections = new ObjectArrayList<PathFinder.ConnectionDetails<PositionAndPlatform>>();
        Platform platform2 = platform = data.platformId == 0L ? null : (Platform)this.simulator.platformIdMap.get(data.platformId);
        if (platform != null) {
            Long2LongAVLTreeMap visitedPlatformTimes = new Long2LongAVLTreeMap();
            platform.routes.forEach(route -> route.depots.forEach(depot -> depot.savedRails.forEach(siding -> siding.getArrivals(this.startMillis, data.platformId, (newPlatformId, routeId, departureTime, duration) -> {
                if (departureTime > this.startMillis + elapsedTime && departureTime < visitedPlatformTimes.getOrDefault(newPlatformId, Long.MAX_VALUE)) {
                    Position position = (Position)this.simulator.platformIdToPosition.get(newPlatformId);
                    if (position != null) {
                        connections.add(new PathFinder.ConnectionDetails<PositionAndPlatform>(new PositionAndPlatform(position, newPlatformId), duration, departureTime - this.startMillis - elapsedTime, routeId));
                    }
                    visitedPlatformTimes.put(newPlatformId, departureTime);
                }
            }))));
        }
        if (previousRouteId == null || previousRouteId != 0L) {
            this.simulator.platformIdToPosition.forEach((newPlatformId, platformPosition) -> {
                long distance = data.position.manhattanDistance((Position)platformPosition);
                if (distance <= this.maxWalkingDistance) {
                    connections.add(new PathFinder.ConnectionDetails<PositionAndPlatform>(new PositionAndPlatform((Position)platformPosition, (long)newPlatformId), distance * 1000L, 0L, 0L));
                }
            });
            long distance = data.position.manhattanDistance(((PositionAndPlatform)this.endNode).position);
            if (distance <= this.maxWalkingDistance) {
                connections.add(new PathFinder.ConnectionDetails<Object>(this.endNode, distance * 1000L, 0L, 0L));
            }
        }
        return connections;
    }

    @Override
    protected long getWeightFromEndNode(PositionAndPlatform node) {
        return node.position.manhattanDistance(((PositionAndPlatform)this.endNode).position);
    }

    public boolean tick() {
        ObjectArrayList connectionDetailsList = this.findPath();
        if (connectionDetailsList == null) {
            return false;
        }
        if (connectionDetailsList.isEmpty()) {
            this.sendResponse.accept(Utilities.getJsonObjectFromData(new DirectionsResponse(this.startMillis)));
            return true;
        }
        if (!((PositionAndPlatform)connectionDetailsList.get((int)0).node).equals(this.startNode)) {
            connectionDetailsList.add(0, new PathFinder.ConnectionDetails<Object>(this.startNode, 0L, 0L, 0L));
        }
        DirectionsResponse directionsResponse = new DirectionsResponse(this.startMillis);
        for (int i = 1; i < connectionDetailsList.size(); ++i) {
            PathFinder.ConnectionDetails connectionDetails1 = connectionDetailsList.get(i - 1);
            PathFinder.ConnectionDetails connectionDetails2 = connectionDetailsList.get(i);
            Platform startPlatform = (Platform)this.simulator.platformIdMap.get(((PositionAndPlatform)connectionDetails1.node).platformId);
            Platform endPlatform = (Platform)this.simulator.platformIdMap.get(((PositionAndPlatform)connectionDetails2.node).platformId);
            Route route = (Route)this.simulator.routeIdMap.get(connectionDetails2.routeId);
            directionsResponse.addSegment(startPlatform, endPlatform, route, connectionDetails2.duration, connectionDetails2.waitingTime);
        }
        this.sendResponse.accept(Utilities.getJsonObjectFromData(directionsResponse));
        return true;
    }

    protected static final class PositionAndPlatform {
        private final Position position;
        private final long platformId;

        private PositionAndPlatform(Position position, long platformId) {
            this.position = position;
            this.platformId = platformId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PositionAndPlatform) {
                return this.platformId == ((PositionAndPlatform)obj).platformId && this.position.equals(((PositionAndPlatform)obj).position);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return (int)((long)this.position.hashCode() ^ this.platformId);
        }
    }
}

