/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.simulation;

import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.core.Main;
import org.mtr.core.data.Client;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Lift;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Position;
import org.mtr.core.data.Rail;
import org.mtr.core.data.Route;
import org.mtr.core.data.Siding;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehiclePosition;
import org.mtr.core.integration.Response;
import org.mtr.core.path.DirectionsPathFinder;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.SerializedDataBaseWithId;
import org.mtr.core.servlet.HttpResponseStatus;
import org.mtr.core.simulation.FileLoader;
import org.mtr.core.tool.RequestHelper;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.data.LegacyRailLoader;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;

public class Simulator
extends Data
implements Utilities {
    private long lastMillis;
    private long currentMillis;
    private boolean autoSave = false;
    private long gameMillis;
    private long gameMillisPerDay = 1200000L;
    private boolean isTimeMoving;
    private long lastSetGameMillisMidnight;
    public final Object2ObjectOpenHashMap<String, Client> clients = new Object2ObjectOpenHashMap();
    public final String dimension;
    public final String[] dimensions;
    private final int clientWebserverPort;
    private final FileLoader<Station> fileLoaderStations;
    private final FileLoader<Platform> fileLoaderPlatforms;
    private final FileLoader<Siding> fileLoaderSidings;
    private final FileLoader<Route> fileLoaderRoutes;
    private final FileLoader<Depot> fileLoaderDepots;
    private final FileLoader<Lift> fileLoaderLifts;
    private final FileLoader<Rail> fileLoaderRails;
    private final ObjectArrayList<Runnable> queuedRuns = new ObjectArrayList();
    private final ObjectImmutableList<ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>>> vehiclePositions;
    private final Object2LongOpenHashMap<UUID> ridingVehicleIds = new Object2LongOpenHashMap();
    private final ObjectOpenHashSet<DirectionsPathFinder> directionsPathFinders = new ObjectOpenHashSet();
    public static final RequestHelper REQUEST_HELPER = new RequestHelper(false);

    public Simulator(String dimension, String[] dimensions, Path rootPath, int clientWebserverPort) {
        this.dimension = dimension;
        this.dimensions = dimensions;
        this.clientWebserverPort = clientWebserverPort;
        long startMillis = System.currentTimeMillis();
        Path savePath = rootPath.resolve(dimension);
        LegacyRailLoader.load(savePath, this.rails);
        this.fileLoaderStations = new FileLoader<Station>(this.stations, messagePackHelper -> new Station((ReaderBase)messagePackHelper, (Data)this), savePath, "stations");
        this.fileLoaderPlatforms = new FileLoader<Platform>(this.platforms, messagePackHelper -> new Platform((ReaderBase)messagePackHelper, (Data)this), savePath, "platforms");
        this.fileLoaderSidings = new FileLoader<Siding>(this.sidings, messagePackHelper -> new Siding((ReaderBase)messagePackHelper, (Data)this), savePath, "sidings");
        this.fileLoaderRoutes = new FileLoader<Route>(this.routes, messagePackHelper -> new Route((ReaderBase)messagePackHelper, (Data)this), savePath, "routes");
        this.fileLoaderDepots = new FileLoader<Depot>(this.depots, messagePackHelper -> new Depot((ReaderBase)messagePackHelper, (Data)this), savePath, "depots");
        this.fileLoaderLifts = new FileLoader<Lift>(this.lifts, messagePackHelper -> new Lift((ReaderBase)messagePackHelper, (Data)this), savePath, "lifts");
        this.fileLoaderRails = new FileLoader<Rail>(this.rails, Rail::new, savePath, "rails");
        this.currentMillis = System.currentTimeMillis();
        Main.LOGGER.info("Data loading complete for {} in {} second(s)", (Object)dimension, (Object)Float.valueOf((float)(this.currentMillis - startMillis) / 1000.0f));
        this.sync();
        this.depots.forEach(Depot::init);
        this.rails.forEach(Rail::checkMigrationStatus);
        ObjectArrayList tempVehiclePositions = new ObjectArrayList();
        for (int i = 0; i < TransportMode.values().length; ++i) {
            ObjectArrayList vehiclePositionsForTransportMode = new ObjectArrayList();
            vehiclePositionsForTransportMode.add(new Object2ObjectAVLTreeMap());
            vehiclePositionsForTransportMode.add(new Object2ObjectAVLTreeMap());
            tempVehiclePositions.add(vehiclePositionsForTransportMode);
        }
        this.vehiclePositions = new ObjectImmutableList(tempVehiclePositions);
        this.sidings.forEach(siding -> siding.initVehiclePositions(this.vehiclePositions.get(siding.getTransportModeOrdinal()).get(1)));
    }

    public void tick() {
        try {
            this.lastMillis = this.currentMillis;
            this.currentMillis = System.currentTimeMillis();
            this.vehiclePositions.forEach((Consumer<ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>>>)((Consumer<ObjectArrayList>)vehiclePositionsForTransportMode -> {
                vehiclePositionsForTransportMode.remove(0);
                vehiclePositionsForTransportMode.add(new Object2ObjectAVLTreeMap());
            }));
            this.rails.forEach(rail -> rail.tick(this));
            this.depots.forEach(Depot::tick);
            if (this.sidings.removeIf(Siding::tick)) {
                this.sync();
            }
            this.sidings.forEach(siding -> siding.simulateTrain(this.currentMillis - this.lastMillis, this.vehiclePositions.get(siding.getTransportModeOrdinal())));
            this.clients.forEach((clientId, client) -> client.sendUpdates(this));
            if (this.autoSave) {
                this.save(true);
                this.autoSave = false;
            }
            this.lifts.forEach(lift -> lift.tick(this.currentMillis - this.lastMillis));
            long startMillis = System.currentTimeMillis();
            while (!this.directionsPathFinders.isEmpty() && System.currentTimeMillis() - startMillis < 400L) {
                this.directionsPathFinders.removeIf(DirectionsPathFinder::tick);
            }
            while (!this.queuedRuns.isEmpty()) {
                Runnable runnable2 = this.queuedRuns.remove(0);
                if (runnable2 == null) continue;
                runnable2.run();
            }
        }
        catch (Throwable e) {
            Main.LOGGER.fatal("", e);
        }
    }

    public void save() {
        this.autoSave = true;
    }

    public void stop() {
        this.save(false);
    }

    public void addDirectionsPathFinder(Position position1, Position position2, long maxWalkingDistance, Consumer<JsonObject> sendResponse) {
        this.directionsPathFinders.add(new DirectionsPathFinder(this, position1, position2, maxWalkingDistance, sendResponse));
    }

    public int matchMillis(long millis) {
        if (Utilities.circularDifference(this.currentMillis, millis, 86400000L) < 0L) {
            return 1;
        }
        return Utilities.circularDifference(millis, this.lastMillis, 86400000L) > 0L ? 0 : -1;
    }

    public void setGameTime(long gameMillis, long gameMillisPerDay, boolean isTimeMoving) {
        this.gameMillis = gameMillisPerDay > 0L ? gameMillis % gameMillisPerDay : gameMillis;
        this.gameMillisPerDay = gameMillisPerDay;
        this.isTimeMoving = isTimeMoving;
        this.lastSetGameMillisMidnight = this.currentMillis - gameMillis;
        this.depots.forEach(Depot::generatePlatformDirectionsAndWriteDeparturesToSidings);
    }

    public long getGameMillisPerDay() {
        return this.gameMillisPerDay;
    }

    public boolean isTimeMoving() {
        return this.isTimeMoving;
    }

    public long getMillisOfGameMidnight() {
        return this.gameMillisPerDay > 0L && this.isTimeMoving ? Math.max(0L, this.lastSetGameMillisMidnight - this.lastSetGameMillisMidnight / this.gameMillisPerDay * this.gameMillisPerDay) : 0L;
    }

    public int getHour() {
        return this.gameMillisPerDay > 0L ? (int)(this.gameMillis * 24L / this.gameMillisPerDay) : 0;
    }

    public void run(Runnable runnable2) {
        this.queuedRuns.add(runnable2);
    }

    public boolean isRiding(UUID uuid, long vehicleId) {
        return this.ridingVehicleIds.getLong(uuid) == vehicleId;
    }

    public void ride(UUID uuid, long vehicleId) {
        this.ridingVehicleIds.put(uuid, vehicleId);
    }

    public void stopRiding(UUID uuid) {
        this.ridingVehicleIds.removeLong(uuid);
    }

    private void save(boolean useReducedHash) {
        long startMillis = System.currentTimeMillis();
        this.save(this.fileLoaderStations, useReducedHash);
        this.save(this.fileLoaderPlatforms, useReducedHash);
        this.save(this.fileLoaderSidings, useReducedHash);
        this.save(this.fileLoaderRoutes, useReducedHash);
        this.save(this.fileLoaderDepots, useReducedHash);
        this.save(this.fileLoaderLifts, useReducedHash);
        this.save(this.fileLoaderRails, useReducedHash);
        Main.LOGGER.info("Save complete for {} in {} second(s)", (Object)this.dimension, (Object)Float.valueOf((float)(System.currentTimeMillis() - startMillis) / 1000.0f));
    }

    private <T extends SerializedDataBaseWithId> void save(FileLoader<T> fileLoader, boolean useReducedHash) {
        IntIntImmutablePair saveCounts = fileLoader.save(useReducedHash);
        if (saveCounts.leftInt() > 0) {
            Main.LOGGER.info("- Changed {}: {}", (Object)fileLoader.key, (Object)saveCounts.leftInt());
        }
        if (saveCounts.rightInt() > 0) {
            Main.LOGGER.info("- Deleted {}: {}", (Object)fileLoader.key, (Object)saveCounts.rightInt());
        }
    }

    public void sendHttpRequest(String endpoint, SerializedDataBase data, @Nullable Consumer<JsonObject> consumer) {
        REQUEST_HELPER.sendPostRequest(String.format("http://localhost:%s/%s", this.clientWebserverPort, endpoint), new Response(HttpResponseStatus.OK.code, System.currentTimeMillis(), "Success", Utilities.getJsonObjectFromData(data)).getJson(), consumer);
    }
}

