/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.tool;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.core.Main;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.okhttp3.Call;
import org.mtr.libraries.okhttp3.Callback;
import org.mtr.libraries.okhttp3.MediaType;
import org.mtr.libraries.okhttp3.OkHttpClient;
import org.mtr.libraries.okhttp3.Request;
import org.mtr.libraries.okhttp3.RequestBody;
import org.mtr.libraries.okhttp3.Response;
import org.mtr.libraries.okhttp3.ResponseBody;

public final class RequestHelper {
    private Call call;
    private final boolean canInterrupt;
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).readTimeout(2L, TimeUnit.SECONDS).build();

    public RequestHelper(boolean canInterrupt) {
        this.canInterrupt = canInterrupt;
    }

    public void sendPostRequest(String url, JsonObject contentObject, @Nullable Consumer<JsonObject> consumer) {
        this.sendRequest(url, contentObject.toString(), consumer == null ? null : response -> consumer.accept(Utilities.parseJson(response)));
    }

    public void sendRequest(String url, @Nullable String content, final @Nullable Consumer<String> consumer) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        Request request = content == null ? requestBuilder.get().build() : requestBuilder.post(RequestBody.create(content, MediaType.get("application/json"))).build();
        if (this.canInterrupt && this.call != null) {
            this.call.cancel();
        }
        this.call = this.okHttpClient.newCall(request);
        this.call.enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                if (!(e instanceof InterruptedIOException)) {
                    Main.LOGGER.error((Object)call.request().url(), (Throwable)e);
                }
            }

            @Override
            public void onResponse(Call call, Response response) {
                block15: {
                    try (ResponseBody responseBody = response.body();){
                        if (consumer != null) {
                            consumer.accept(responseBody.string());
                        }
                    }
                    catch (IOException e) {
                        if (e instanceof InterruptedIOException) break block15;
                        Main.LOGGER.error((Object)call.request().url(), (Throwable)e);
                    }
                }
            }
        });
    }
}

