/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.legacy.resource;

import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.generated.resource.ObjectResourceSchema;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mod.resource.ObjectResource;

public final class LegacyObjectResource
extends ObjectResourceSchema {
    public LegacyObjectResource(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public ObjectResource convert(String id) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", id);
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("color", 0);
        jsonObject.addProperty("modelResource", this.model);
        jsonObject.addProperty("textureResource", this.textureId);
        jsonObject.addProperty("flipTextureV", this.flipV);
        JsonObject baseObject = Utilities.getJsonObjectFromData(this);
        LegacyObjectResource.putArray1(baseObject, jsonObject, "translation");
        LegacyObjectResource.putArray1(baseObject, jsonObject, "rotation");
        LegacyObjectResource.putArray1(baseObject, jsonObject, "scale");
        LegacyObjectResource.putArray2(baseObject, jsonObject, "mirror");
        return new ObjectResource(new JsonReader(jsonObject));
    }

    private static void putArray1(JsonObject baseObject, JsonObject newObject, String key) {
        try {
            JsonArray jsonArray = baseObject.getAsJsonArray(key);
            JsonObject childObject = new JsonObject();
            childObject.addProperty("x", jsonArray.get(0).getAsDouble());
            childObject.addProperty("y", jsonArray.get(1).getAsDouble());
            childObject.addProperty("z", jsonArray.get(2).getAsDouble());
            newObject.add(key, childObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void putArray2(JsonObject baseObject, JsonObject newObject, String key) {
        try {
            JsonArray jsonArray = baseObject.getAsJsonArray(key);
            JsonObject childObject = new JsonObject();
            childObject.addProperty("x", jsonArray.get(0).getAsBoolean());
            childObject.addProperty("y", jsonArray.get(1).getAsBoolean());
            childObject.addProperty("z", jsonArray.get(2).getAsBoolean());
            newObject.add(key, childObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

