/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.mtr.libraries.kotlin.Metadata;
import org.mtr.libraries.kotlin.TuplesKt;
import org.mtr.libraries.kotlin.Unit;
import org.mtr.libraries.kotlin.collections.CollectionsKt;
import org.mtr.libraries.kotlin.collections.MapsKt;
import org.mtr.libraries.kotlin.jvm.functions.Function3;
import org.mtr.libraries.kotlin.jvm.internal.DefaultConstructorMarker;
import org.mtr.libraries.kotlin.jvm.internal.Intrinsics;
import org.mtr.libraries.kotlin.jvm.internal.SourceDebugExtension;
import org.mtr.libraries.okhttp3.Address;
import org.mtr.libraries.okhttp3.ConnectionListener;
import org.mtr.libraries.okhttp3.ConnectionPool;
import org.mtr.libraries.okhttp3.Route;
import org.mtr.libraries.okhttp3.internal._UtilJvmKt;
import org.mtr.libraries.okhttp3.internal.concurrent.Task;
import org.mtr.libraries.okhttp3.internal.concurrent.TaskQueue;
import org.mtr.libraries.okhttp3.internal.concurrent.TaskRunner;
import org.mtr.libraries.okhttp3.internal.connection.ConnectionUser;
import org.mtr.libraries.okhttp3.internal.connection.ExchangeFinder;
import org.mtr.libraries.okhttp3.internal.connection.PoolConnectionUser;
import org.mtr.libraries.okhttp3.internal.connection.RealCall;
import org.mtr.libraries.okhttp3.internal.connection.RealConnection;
import org.mtr.libraries.okhttp3.internal.connection.RealConnectionPool;
import org.mtr.libraries.okhttp3.internal.platform.Platform;
import org.mtr.libraries.org.jetbrains.annotations.NotNull;
import org.mtr.libraries.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0018\u0018\u0000 @2\u00020\u0001:\u0002?@BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J8\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000f2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(2\u0006\u0010*\u001a\u00020$J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007J\u000e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u001eJ\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u0005J$\u00103\u001a\u00020$2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0010\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0014H\u0002J\u0018\u00106\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u000e\u00107\u001a\u0002012\u0006\u0010.\u001a\u00020\u001eJ\u0006\u00108\u001a\u000201J\u000e\u00109\u001a\u0002012\u0006\u0010%\u001a\u00020\u000eJ\u0016\u0010:\u001a\u0002012\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<J\u0014\u0010=\u001a\u00020\u0007*\u00020\u00072\u0006\u0010>\u001a\u00020\u0005H\u0002J\f\u00109\u001a\u000201*\u00020\u0014H\u0002R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lorg/mtr/libraries/okhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "connectionListener", "Lorg/mtr/libraries/okhttp3/ConnectionListener;", "exchangeFinderFactory", "Lorg/mtr/libraries/kotlin/Function3;", "Lorg/mtr/libraries/okhttp3/Address;", "Lorg/mtr/libraries/okhttp3/internal/connection/ConnectionUser;", "Lorg/mtr/libraries/okhttp3/internal/connection/ExchangeFinder;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;Lokhttp3/ConnectionListener;Lkotlin/jvm/functions/Function3;)V", "addressStates", "", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool$AddressState;", "cleanupQueue", "Lorg/mtr/libraries/okhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "org/mtr/libraries/okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "getConnectionListener$okhttp", "()Lokhttp3/ConnectionListener;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "getKeepAliveDurationNs$okhttp", "()J", "callAcquirePooledConnection", "doExtensiveHealthChecks", "", "address", "connectionUser", "routes", "", "Lorg/mtr/libraries/okhttp3/Route;", "requireMultiplexed", "closeConnections", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "isEvictable", "openConnections", "state", "pruneAndGetAllocationCount", "put", "scheduleCloser", "scheduleOpener", "setPolicy", "policy", "Lorg/mtr/libraries/okhttp3/ConnectionPool$AddressPolicy;", "jitterBy", "amount", "AddressState", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,470:1\n1#2:471\n1774#3,4:472\n353#4,4:476\n353#4,4:480\n353#4,4:484\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n82#1:472,4\n148#1:476,4\n160#1:480,4\n339#1:484,4\n*E\n"})
public final class RealConnectionPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner taskRunner;
    private final int maxIdleConnections;
    @NotNull
    private final ConnectionListener connectionListener;
    @NotNull
    private final Function3<RealConnectionPool, Address, ConnectionUser, ExchangeFinder> exchangeFinderFactory;
    private final long keepAliveDurationNs;
    @NotNull
    private volatile Map<Address, AddressState> addressStates;
    @NotNull
    private final TaskQueue cleanupQueue;
    @NotNull
    private final cleanupTask.1 cleanupTask;
    @NotNull
    private final ConcurrentLinkedQueue<RealConnection> connections;
    private static AtomicReferenceFieldUpdater<RealConnectionPool, Map<?, ?>> addressStatesUpdater = AtomicReferenceFieldUpdater.newUpdater(RealConnectionPool.class, Map.class, "addressStates");

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, @NotNull TimeUnit timeUnit, @NotNull ConnectionListener connectionListener, @NotNull Function3<? super RealConnectionPool, ? super Address, ? super ConnectionUser, ? extends ExchangeFinder> exchangeFinderFactory) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        Intrinsics.checkNotNullParameter(connectionListener, "connectionListener");
        Intrinsics.checkNotNullParameter(exchangeFinderFactory, "exchangeFinderFactory");
        this.taskRunner = taskRunner;
        this.maxIdleConnections = maxIdleConnections;
        this.connectionListener = connectionListener;
        this.exchangeFinderFactory = exchangeFinderFactory;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.addressStates = MapsKt.emptyMap();
        this.cleanupQueue = this.taskRunner.newQueue();
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection closer";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return this.this$0.closeConnections(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            boolean bl = false;
            String string2 = "keepAliveDuration <= 0: " + keepAliveDuration;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final ConnectionListener getConnectionListener$okhttp() {
        return this.connectionListener;
    }

    public final long getKeepAliveDurationNs$okhttp() {
        return this.keepAliveDurationNs;
    }

    private final void scheduleOpener(AddressState $this$scheduleOpener) {
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection opener";
        TaskQueue.schedule$default($this$scheduleOpener.getQueue(), new Task(this, $this$scheduleOpener, string){
            final /* synthetic */ RealConnectionPool this$0;
            final /* synthetic */ AddressState $this_scheduleOpener;
            {
                this.this$0 = $receiver;
                this.$this_scheduleOpener = $receiver2;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return RealConnectionPool.access$openConnections(this.this$0, this.$this_scheduleOpener);
            }
        }, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int idleConnectionCount() {
        int n;
        Iterable $this$count$iv = this.connections;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                RealConnection it = (RealConnection)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                RealConnection realConnection = it;
                synchronized (realConnection) {
                    boolean bl3 = false;
                    bl = it.getCalls().isEmpty();
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RealConnection callAcquirePooledConnection(boolean doExtensiveHealthChecks, @NotNull Address address, @NotNull ConnectionUser connectionUser, @Nullable List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(connectionUser, "connectionUser");
        for (RealConnection connection : this.connections) {
            Socket socket;
            boolean bl;
            Intrinsics.checkNotNull(connection);
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                boolean bl2;
                boolean bl3 = false;
                if (requireMultiplexed && !connection.isMultiplexed$okhttp()) {
                    bl2 = false;
                } else if (!connection.isEligible$okhttp(address, routes)) {
                    bl2 = false;
                } else {
                    connectionUser.acquireConnectionNoEvents(connection);
                    bl2 = true;
                }
                bl = bl2;
            }
            boolean acquired = bl;
            if (!acquired) continue;
            if (connection.isHealthy(doExtensiveHealthChecks)) {
                return connection;
            }
            boolean noNewExchangesEvent = false;
            RealConnection realConnection2 = connection;
            synchronized (realConnection2) {
                boolean bl4 = false;
                noNewExchangesEvent = !connection.getNoNewExchanges();
                connection.setNoNewExchanges(true);
                socket = connectionUser.releaseConnectionNoEvents();
            }
            Socket toClose = socket;
            if (toClose != null) {
                _UtilJvmKt.closeQuietly(toClose);
                this.connectionListener.connectionClosed(connection);
                continue;
            }
            if (!noNewExchangesEvent) continue;
            this.connectionListener.noNewExchanges(connection);
        }
        return null;
    }

    public final void put(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        this.connections.add(connection);
        this.scheduleCloser();
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection connection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(connection, "connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            connection.setNoNewExchanges(true);
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            this.scheduleOpener(connection.getRoute().address());
            bl = true;
        } else {
            this.scheduleCloser();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<RealConnection> i = iterator2;
        while (i.hasNext()) {
            Socket socket;
            RealConnection connection = i.next();
            Intrinsics.checkNotNull(connection);
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                Socket socket2;
                boolean bl = false;
                if (connection.getCalls().isEmpty()) {
                    i.remove();
                    connection.setNoNewExchanges(true);
                    socket2 = connection.socket();
                } else {
                    socket2 = null;
                }
                socket = socket2;
            }
            Socket socketToClose = socket;
            if (socketToClose == null) continue;
            _UtilJvmKt.closeQuietly(socketToClose);
            this.connectionListener.connectionClosed(connection);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
        for (AddressState policy : this.addressStates.values()) {
            this.scheduleOpener(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long closeConnections(long now) {
        RealConnection realConnection;
        Map<Address, AddressState> addressStates = this.addressStates;
        for (AddressState state : addressStates.values()) {
            state.setConcurrentCallCapacity(0);
        }
        for (RealConnection connection : this.connections) {
            if (addressStates.get(connection.getRoute().address()) == null) continue;
            Intrinsics.checkNotNull(connection);
            RealConnection realConnection2 = connection;
            synchronized (realConnection2) {
                AddressState addressState;
                boolean $i$a$-synchronized-RealConnectionPool$closeConnections$42 = false;
                addressState.setConcurrentCallCapacity(addressState.getConcurrentCallCapacity() + connection.getAllocationLimit$okhttp());
                Unit $i$a$-synchronized-RealConnectionPool$closeConnections$42 = Unit.INSTANCE;
            }
        }
        long earliestOldIdleAtNs = 0L;
        earliestOldIdleAtNs = now - this.keepAliveDurationNs + 1L;
        RealConnection earliestOldConnection = null;
        long earliestEvictableIdleAtNs = 0L;
        earliestEvictableIdleAtNs = Long.MAX_VALUE;
        RealConnection earliestEvictableConnection = null;
        int inUseConnectionCount = 0;
        int evictableConnectionCount = 0;
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNull(connection);
            realConnection = connection;
            synchronized (realConnection) {
                boolean $i$a$-synchronized-RealConnectionPool$closeConnections$52 = false;
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    ++inUseConnectionCount;
                } else {
                    long idleAtNs = connection.getIdleAtNs();
                    if (idleAtNs < earliestOldIdleAtNs) {
                        earliestOldIdleAtNs = idleAtNs;
                        earliestOldConnection = connection;
                    }
                    if (this.isEvictable(addressStates, connection)) {
                        ++evictableConnectionCount;
                        if (idleAtNs < earliestEvictableIdleAtNs) {
                            earliestEvictableIdleAtNs = idleAtNs;
                            earliestEvictableConnection = connection;
                        }
                    }
                }
                Unit $i$a$-synchronized-RealConnectionPool$closeConnections$52 = Unit.INSTANCE;
            }
        }
        RealConnection toEvict = null;
        long toEvictIdleAtNs = 0L;
        if (earliestOldConnection != null) {
            toEvict = earliestOldConnection;
            toEvictIdleAtNs = earliestOldIdleAtNs;
        } else if (evictableConnectionCount > this.maxIdleConnections) {
            toEvict = earliestEvictableConnection;
            toEvictIdleAtNs = earliestEvictableIdleAtNs;
        } else {
            toEvict = null;
            toEvictIdleAtNs = -1L;
        }
        if (toEvict != null) {
            realConnection = toEvict;
            synchronized (realConnection) {
                block29: {
                    block28: {
                        boolean bl = false;
                        if (!(!((Collection)toEvict.getCalls()).isEmpty())) break block28;
                        long l = 0L;
                        return l;
                    }
                    if (toEvict.getIdleAtNs() == toEvictIdleAtNs) break block29;
                    long l = 0L;
                    return l;
                }
                toEvict.setNoNewExchanges(true);
                boolean bl = this.connections.remove(toEvict);
            }
            AddressState addressState = addressStates.get(toEvict.getRoute().address());
            if (addressState != null) {
                this.scheduleOpener(addressState);
            }
            _UtilJvmKt.closeQuietly(toEvict.socket());
            this.connectionListener.connectionClosed(toEvict);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (earliestEvictableConnection != null) {
            return earliestEvictableIdleAtNs + this.keepAliveDurationNs - now;
        }
        if (inUseConnectionCount > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final boolean isEvictable(Map<Address, AddressState> addressStates, RealConnection connection) {
        AddressState addressState = addressStates.get(connection.getRoute().address());
        if (addressState == null) {
            return true;
        }
        AddressState addressState2 = addressState;
        int capacityWithoutIt = addressState2.getConcurrentCallCapacity() - connection.getAllocationLimit$okhttp();
        return capacityWithoutIt >= addressState2.getPolicy().minimumConcurrentCalls;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull(reference, "null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNs(now - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public final void setPolicy(@NotNull Address address, @NotNull ConnectionPool.AddressPolicy policy) {
        Map<Address, AddressState> newMap;
        Map<Address, AddressState> oldMap;
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(policy, "policy");
        AddressState state = new AddressState(address, this.taskRunner.newQueue(), policy);
        int newConnectionsNeeded = 0;
        while (!addressStatesUpdater.compareAndSet(this, oldMap = this.addressStates, newMap = MapsKt.plus(oldMap, TuplesKt.to(address, state)))) {
        }
        Object object = oldMap.get(address);
        int oldPolicyMinimumConcurrentCalls = object != null && (object = ((AddressState)object).getPolicy()) != null ? ((ConnectionPool.AddressPolicy)object).minimumConcurrentCalls : 0;
        newConnectionsNeeded = policy.minimumConcurrentCalls - oldPolicyMinimumConcurrentCalls;
        if (newConnectionsNeeded > 0) {
            this.scheduleOpener(state);
        } else if (newConnectionsNeeded < 0) {
            this.scheduleCloser();
        }
    }

    public final void scheduleOpener(@NotNull Address address) {
        block0: {
            Intrinsics.checkNotNullParameter(address, "address");
            AddressState addressState = this.addressStates.get(address);
            if (addressState == null) break block0;
            this.scheduleOpener(addressState);
        }
    }

    public final void scheduleCloser() {
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long openConnections(AddressState state) {
        if (state.getPolicy().minimumConcurrentCalls == 0) {
            return -1L;
        }
        int concurrentCallCapacity = 0;
        for (RealConnection connection : this.connections) {
            if (!Intrinsics.areEqual(state.getAddress(), connection.getRoute().address())) continue;
            Intrinsics.checkNotNull(connection);
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
            }
            if ((concurrentCallCapacity += connection.getAllocationLimit$okhttp()) < state.getPolicy().minimumConcurrentCalls) continue;
            return -1L;
        }
        try {
            RealConnection connection = this.exchangeFinderFactory.invoke(this, state.getAddress(), PoolConnectionUser.INSTANCE).find();
            if (!this.connections.contains(connection)) {
                RealConnection realConnection = connection;
                synchronized (realConnection) {
                    boolean bl = false;
                    this.put(connection);
                    Unit unit = Unit.INSTANCE;
                }
            }
            return 0L;
        }
        catch (IOException e) {
            return this.jitterBy(state.getPolicy().backoffDelayMillis, state.getPolicy().backoffJitterMillis) * (long)1000000;
        }
    }

    private final long jitterBy(long $this$jitterBy, int amount) {
        return $this$jitterBy + (long)ThreadLocalRandom.current().nextInt(amount * -1, amount);
    }

    public static final /* synthetic */ long access$openConnections(RealConnectionPool $this, AddressState state) {
        return $this.openConnections(state);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool$AddressState;", "", "address", "Lorg/mtr/libraries/okhttp3/Address;", "queue", "Lorg/mtr/libraries/okhttp3/internal/concurrent/TaskQueue;", "policy", "Lorg/mtr/libraries/okhttp3/ConnectionPool$AddressPolicy;", "(Lokhttp3/Address;Lokhttp3/internal/concurrent/TaskQueue;Lokhttp3/ConnectionPool$AddressPolicy;)V", "getAddress", "()Lokhttp3/Address;", "concurrentCallCapacity", "", "getConcurrentCallCapacity", "()I", "setConcurrentCallCapacity", "(I)V", "getPolicy", "()Lokhttp3/ConnectionPool$AddressPolicy;", "setPolicy", "(Lokhttp3/ConnectionPool$AddressPolicy;)V", "getQueue", "()Lokhttp3/internal/concurrent/TaskQueue;", "okhttp"})
    public static final class AddressState {
        @NotNull
        private final Address address;
        @NotNull
        private final TaskQueue queue;
        @NotNull
        private ConnectionPool.AddressPolicy policy;
        private int concurrentCallCapacity;

        public AddressState(@NotNull Address address, @NotNull TaskQueue queue, @NotNull ConnectionPool.AddressPolicy policy) {
            Intrinsics.checkNotNullParameter(address, "address");
            Intrinsics.checkNotNullParameter(queue, "queue");
            Intrinsics.checkNotNullParameter(policy, "policy");
            this.address = address;
            this.queue = queue;
            this.policy = policy;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @NotNull
        public final TaskQueue getQueue() {
            return this.queue;
        }

        @NotNull
        public final ConnectionPool.AddressPolicy getPolicy() {
            return this.policy;
        }

        public final void setPolicy(@NotNull ConnectionPool.AddressPolicy addressPolicy) {
            Intrinsics.checkNotNullParameter(addressPolicy, "<set-?>");
            this.policy = addressPolicy;
        }

        public final int getConcurrentCallCapacity() {
            return this.concurrentCallCapacity;
        }

        public final void setConcurrentCallCapacity(int n) {
            this.concurrentCallCapacity = n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nRn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "addressStatesUpdater", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnectionPool;", "org.mtr.libraries.kotlin.jvm.PlatformType", "", "get", "connectionPool", "Lorg/mtr/libraries/okhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

