/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.levelgen.Heightmap;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum HeightMapType {
    WORLD_SURFACE_WG(Heightmap.Types.WORLD_SURFACE_WG),
    WORLD_SURFACE(Heightmap.Types.WORLD_SURFACE),
    OCEAN_FLOOR_WG(Heightmap.Types.OCEAN_FLOOR_WG),
    OCEAN_FLOOR(Heightmap.Types.OCEAN_FLOOR),
    MOTION_BLOCKING(Heightmap.Types.MOTION_BLOCKING),
    MOTION_BLOCKING_NO_LEAVES(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);

    public final Heightmap.Types data;

    private HeightMapType(Heightmap.Types data) {
        this.data = data;
    }

    public static HeightMapType convert(@Nullable Heightmap.Types data) {
        return data == null ? null : HeightMapType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable HeightMapType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getOceanFloorWgMapped() {
        return HeightMapType.convert(Heightmap.Types.OCEAN_FLOOR_WG);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getWorldSurfaceMapped() {
        return HeightMapType.convert(Heightmap.Types.WORLD_SURFACE);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getWorldSurfaceWgMapped() {
        return HeightMapType.convert(Heightmap.Types.WORLD_SURFACE_WG);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getMotionBlockingNoLeavesMapped() {
        return HeightMapType.convert(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getOceanFloorMapped() {
        return HeightMapType.convert(Heightmap.Types.OCEAN_FLOOR);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getMotionBlockingMapped() {
        return HeightMapType.convert(Heightmap.Types.MOTION_BLOCKING);
    }
}

