/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.Difficulty;
import org.mtr.mapping.holder.DimensionType;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.FluidState;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.ParticleEffect;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ServerWorldAccess
extends HolderBase<ServerLevelAccessor> {
    public ServerWorldAccess(ServerLevelAccessor data) {
        super(data);
    }

    @MappedMethod
    public static ServerWorldAccess cast(HolderBase<?> data) {
        return new ServerWorldAccess((ServerLevelAccessor)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof ServerLevelAccessor;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((ServerLevelAccessor)this.data).equals(((HolderBase)data).data);
    }

    @MappedMethod
    public boolean isClient() {
        return ((ServerLevelAccessor)this.data).m_5776_();
    }

    @Nullable
    @MappedMethod
    public BlockHitResult raycastBlock(Vector3d arg0, Vector3d arg1, BlockPos arg2, VoxelShape arg3, BlockState arg4) {
        net.minecraft.world.phys.BlockHitResult tempData = ((ServerLevelAccessor)this.data).m_45558_((Vec3)arg0.data, (Vec3)arg1.data, (net.minecraft.core.BlockPos)arg2.data, (net.minecraft.world.phys.shapes.VoxelShape)arg3.data, (net.minecraft.world.level.block.state.BlockState)arg4.data);
        return tempData == null ? null : new BlockHitResult(tempData);
    }

    @MappedMethod
    public float getBrightness(Direction arg0, boolean arg1) {
        return ((ServerLevelAccessor)this.data).m_7717_(arg0.data, arg1);
    }

    @MappedMethod
    public float getSkyAngle(float arg0) {
        return ((ServerLevelAccessor)this.data).m_46942_(arg0);
    }

    @MappedMethod
    public double getDismountHeight(BlockPos arg0) {
        return ((ServerLevelAccessor)this.data).m_45573_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public void syncWorldEvent(int arg0, BlockPos arg1, int arg2) {
        ((ServerLevelAccessor)this.data).m_46796_(arg0, (net.minecraft.core.BlockPos)arg1.data, arg2);
    }

    @MappedMethod
    public void syncWorldEvent(@Nullable PlayerEntity arg0, int arg1, BlockPos arg2, int arg3) {
        ((ServerLevelAccessor)this.data).m_5898_(arg0 == null ? null : (Player)arg0.data, arg1, (net.minecraft.core.BlockPos)arg2.data, arg3);
    }

    @Nonnull
    @MappedMethod
    public Random getRandom() {
        return new Random(((ServerLevelAccessor)this.data).m_213780_());
    }

    @Nonnull
    @MappedMethod
    public BlockState getBlockState(BlockPos arg0) {
        return new BlockState(((ServerLevelAccessor)this.data).m_8055_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((ServerLevelAccessor)this.data).m_7106_((ParticleOptions)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @Nonnull
    @MappedMethod
    public Difficulty getDifficulty() {
        return Difficulty.convert(((ServerLevelAccessor)this.data).m_46791_());
    }

    @MappedMethod
    public boolean isRegionLoaded(BlockPos arg0, BlockPos arg1) {
        return ((ServerLevelAccessor)this.data).m_46832_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.core.BlockPos)arg1.data);
    }

    @MappedMethod
    public boolean isRegionLoaded(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return ((ServerLevelAccessor)this.data).m_46812_(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    @MappedMethod
    public void spawnEntityAndPassengers(Entity arg0) {
        ((ServerLevelAccessor)this.data).m_47205_((net.minecraft.world.entity.Entity)arg0.data);
    }

    @Nullable
    @MappedMethod
    public BlockEntity getBlockEntity(BlockPos arg0) {
        net.minecraft.world.level.block.entity.BlockEntity tempData = ((ServerLevelAccessor)this.data).m_7702_((net.minecraft.core.BlockPos)arg0.data);
        return tempData == null ? null : new BlockEntity(tempData);
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1) {
        return new Chunk(((ServerLevelAccessor)this.data).m_6325_(arg0, arg1));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(BlockPos arg0) {
        return new Chunk(((ServerLevelAccessor)this.data).m_46865_((net.minecraft.core.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2) {
        return new Chunk(((ServerLevelAccessor)this.data).m_46819_(arg0, arg1, (net.minecraft.world.level.chunk.ChunkStatus)arg2.data));
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        ChunkAccess tempData = ((ServerLevelAccessor)this.data).m_6522_(arg0, arg1, (net.minecraft.world.level.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @Nonnull
    @MappedMethod
    public ChunkManager getChunkManager() {
        return new ChunkManager(((ServerLevelAccessor)this.data).m_7726_());
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(BlockPos arg0) {
        return new FluidState(((ServerLevelAccessor)this.data).m_6425_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public boolean canPlace(BlockState arg0, BlockPos arg1, ShapeContext arg2) {
        return ((ServerLevelAccessor)this.data).m_45752_((net.minecraft.world.level.block.state.BlockState)arg0.data, (net.minecraft.core.BlockPos)arg1.data, (CollisionContext)arg2.data);
    }

    @MappedMethod
    public int getMoonPhase() {
        return ((ServerLevelAccessor)this.data).m_46941_();
    }

    @Nonnull
    @MappedMethod
    public DimensionType getDimension() {
        return new DimensionType(((ServerLevelAccessor)this.data).m_6042_());
    }

    @MappedMethod
    public boolean doesNotIntersectEntities(@Nullable Entity arg0, VoxelShape arg1) {
        return ((ServerLevelAccessor)this.data).m_5450_(arg0 == null ? null : (net.minecraft.world.entity.Entity)arg0.data, (net.minecraft.world.phys.shapes.VoxelShape)arg1.data);
    }

    @MappedMethod
    public long getLunarTime() {
        return ((ServerLevelAccessor)this.data).m_8044_();
    }

    @MappedMethod
    public int getAmbientDarkness() {
        return ((ServerLevelAccessor)this.data).m_7445_();
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2, int arg3) {
        return ((ServerLevelAccessor)this.data).m_6933_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, arg2, arg3);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2) {
        return ((ServerLevelAccessor)this.data).m_7731_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, arg2);
    }

    @MappedMethod
    public boolean removeBlock(BlockPos arg0, boolean arg1) {
        return ((ServerLevelAccessor)this.data).m_7471_((net.minecraft.core.BlockPos)arg0.data, arg1);
    }

    @Nonnull
    @MappedMethod
    public ServerWorld toServerWorld() {
        return new ServerWorld(((ServerLevelAccessor)this.data).m_6018_());
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1) {
        return ((ServerLevelAccessor)this.data).m_46961_((net.minecraft.core.BlockPos)arg0.data, arg1);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2, int arg3) {
        return ((ServerLevelAccessor)this.data).m_7740_((net.minecraft.core.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.world.entity.Entity)arg2.data, arg3);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2) {
        return ((ServerLevelAccessor)this.data).m_46953_((net.minecraft.core.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.world.entity.Entity)arg2.data);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayerByUuid(UUID arg0) {
        Player tempData = ((ServerLevelAccessor)this.data).m_46003_(arg0);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public int getMaxLightLevel() {
        return ((ServerLevelAccessor)this.data).m_7469_();
    }

    @MappedMethod
    public float getMoonSize() {
        return ((ServerLevelAccessor)this.data).m_46940_();
    }

    @Nullable
    @MappedMethod
    public BlockView getChunkAsView(int arg0, int arg1) {
        BlockGetter tempData = ((ServerLevelAccessor)this.data).m_7925_(arg0, arg1);
        return tempData == null ? null : new BlockView(tempData);
    }

    @MappedMethod
    public boolean isPlayerInRange(double arg0, double arg1, double arg2, double arg3) {
        return ((ServerLevelAccessor)this.data).m_45914_(arg0, arg1, arg2, arg3);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(Entity arg0, double arg1) {
        Player tempData = ((ServerLevelAccessor)this.data).m_45930_((net.minecraft.world.entity.Entity)arg0.data, arg1);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(double arg0, double arg1, double arg2, double arg3, boolean arg4) {
        Player tempData = ((ServerLevelAccessor)this.data).m_45924_(arg0, arg1, arg2, arg3, arg4);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public void playSound(@Nullable PlayerEntity arg0, BlockPos arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
        ((ServerLevelAccessor)this.data).m_5594_(arg0 == null ? null : (Player)arg0.data, (net.minecraft.core.BlockPos)arg1.data, (net.minecraft.sounds.SoundEvent)arg2.data, arg3.data, arg4, arg5);
    }

    @Nonnull
    @MappedMethod
    public BlockPos getTopPosition(HeightMapType arg0, BlockPos arg1) {
        return new BlockPos(((ServerLevelAccessor)this.data).m_5452_(arg0.data, (net.minecraft.core.BlockPos)arg1.data));
    }

    @MappedMethod
    public int getLightLevel(LightType arg0, BlockPos arg1) {
        return ((ServerLevelAccessor)this.data).m_45517_(arg0.data, (net.minecraft.core.BlockPos)arg1.data);
    }

    @MappedMethod
    public int getSeaLevel() {
        return ((ServerLevelAccessor)this.data).m_5736_();
    }

    @MappedMethod
    public int getHeight() {
        return ((ServerLevelAccessor)this.data).m_141928_();
    }

    @MappedMethod
    public int getTopY(HeightMapType arg0, int arg1, int arg2) {
        return ((ServerLevelAccessor)this.data).m_6924_(arg0.data, arg1, arg2);
    }

    @MappedMethod
    public void updateNeighbors(BlockPos arg0, Block arg1) {
        ((ServerLevelAccessor)this.data).m_6289_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.Block)arg1.data);
    }
}

