/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.OverlayTexture;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.model.RawMesh;
import org.mtr.mapping.render.model.RawModel;
import org.mtr.mapping.render.obj.AtlasManager;
import org.mtr.mapping.render.obj.ObjModelLoader;
import org.mtr.mapping.render.object.VertexArray;
import org.mtr.mapping.render.vertex.CapturingVertexConsumer;
import org.mtr.mapping.render.vertex.VertexAttributeMapping;
import org.mtr.mapping.render.vertex.VertexAttributeSource;
import org.mtr.mapping.render.vertex.VertexAttributeType;
import org.mtr.mapping.tool.DummyClass;

public final class OptimizedModel
extends DummyClass {
    final List<VertexArray> uploadedParts;
    private static final AtlasManager ATLAS_MANAGER = new AtlasManager();
    private static final VertexAttributeMapping DEFAULT_MAPPING = new VertexAttributeMapping.Builder().set(VertexAttributeType.POSITION, VertexAttributeSource.VERTEX_BUFFER).set(VertexAttributeType.COLOR, VertexAttributeSource.GLOBAL).set(VertexAttributeType.UV_TEXTURE, VertexAttributeSource.VERTEX_BUFFER).set(VertexAttributeType.UV_OVERLAY, VertexAttributeSource.GLOBAL).set(VertexAttributeType.UV_LIGHTMAP, VertexAttributeSource.GLOBAL).set(VertexAttributeType.NORMAL, VertexAttributeSource.VERTEX_BUFFER).set(VertexAttributeType.MATRIX_MODEL, VertexAttributeSource.GLOBAL).build();

    @MappedMethod
    public static OptimizedModel fromMaterialGroups(Collection<MaterialGroup> materialGroups) {
        CapturingVertexConsumer capturingVertexConsumer = new CapturingVertexConsumer();
        materialGroups.forEach(materialGroup -> {
            capturingVertexConsumer.beginStage(materialGroup.materialProperties);
            materialGroup.modelPartConsumers.forEach(modelPartConsumer -> modelPartConsumer.accept(capturingVertexConsumer));
        });
        capturingVertexConsumer.rawModel.triangulate();
        RawModel rawModel = new RawModel();
        capturingVertexConsumer.rawModel.iterateRawMeshList(rawModel::append);
        rawModel.distinct();
        return new OptimizedModel(rawModel.upload(DEFAULT_MAPPING));
    }

    @MappedMethod
    public static OptimizedModel fromObjModels(Collection<ObjModel> objModels) {
        ArrayList<VertexArray> uploadedParts = new ArrayList<VertexArray>();
        objModels.forEach(objModel -> {
            objModel.rawModel.generateNormals();
            objModel.rawModel.distinct();
            uploadedParts.addAll(objModel.rawModel.upload(DEFAULT_MAPPING));
        });
        return new OptimizedModel(uploadedParts);
    }

    private OptimizedModel(List<VertexArray> uploadedParts) {
        this.uploadedParts = uploadedParts;
    }

    @MappedMethod
    public OptimizedModel(OptimizedModel ... optimizedModels) {
        this.uploadedParts = new ArrayList<VertexArray>();
        for (OptimizedModel optimizedModel : optimizedModels) {
            this.uploadedParts.addAll(optimizedModel.uploadedParts);
        }
    }

    public static final class ObjModel {
        private final float minX;
        private final float minY;
        private final float minZ;
        private final float maxX;
        private final float maxY;
        private final float maxZ;
        private final List<RawMesh> rawMeshes;
        private final RawModel rawModel = new RawModel();

        private ObjModel(List<RawMesh> rawMeshes, boolean flipTextureV, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            if (flipTextureV) {
                rawMeshes.forEach(rawMesh -> rawMesh.applyUVMirror(false, true));
            }
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.rawMeshes = rawMeshes;
        }

        @MappedMethod
        public static Map<String, ObjModel> loadModel(Identifier objLocation, Identifier defaultTexture, @Nullable Identifier atlasIndex, boolean splitModel, boolean flipTextureV) {
            if (atlasIndex != null) {
                ATLAS_MANAGER.load(atlasIndex);
            }
            HashMap<String, ObjModel> objModels = new HashMap<String, ObjModel>();
            ObjModelLoader.loadModel(objLocation, defaultTexture, ATLAS_MANAGER, splitModel).forEach((key, rawMeshes) -> {
                float[] bounds = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
                rawMeshes.forEach(rawMesh -> {
                    rawMesh.applyRotation(new Vector3f(1.0f, 0.0f, 0.0f), 180.0f);
                    rawMesh.vertices.forEach(vertex -> {
                        float x = vertex.position.getX();
                        float y = vertex.position.getY();
                        float z = vertex.position.getZ();
                        bounds[0] = Math.min(bounds[0], x);
                        bounds[1] = Math.min(bounds[1], y);
                        bounds[2] = Math.min(bounds[2], z);
                        bounds[3] = Math.max(bounds[3], x);
                        bounds[4] = Math.max(bounds[4], y);
                        bounds[5] = Math.max(bounds[5], z);
                    });
                });
                objModels.put((String)key, new ObjModel((List<RawMesh>)rawMeshes, flipTextureV, bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]));
            });
            return objModels;
        }

        @MappedMethod
        public void addTransformation(ShaderType shaderType, double x, double y, double z, boolean flipped) {
            this.rawMeshes.forEach(rawMesh -> {
                RawMesh newRawMesh = new RawMesh(shaderType, (RawMesh)rawMesh);
                newRawMesh.applyTranslation((float)x, (float)y, (float)z);
                if (flipped) {
                    newRawMesh.applyRotation(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f);
                }
                this.rawModel.append(newRawMesh);
            });
        }

        @MappedMethod
        public void applyTranslation(double x, double y, double z) {
            this.rawMeshes.forEach(rawMesh -> rawMesh.applyTranslation((float)x, (float)y, (float)z));
        }

        @MappedMethod
        public void applyRotation(double x, double y, double z) {
            this.rawMeshes.forEach(rawMesh -> {
                rawMesh.applyRotation(new Vector3f(1.0f, 0.0f, 0.0f), (float)x);
                rawMesh.applyRotation(new Vector3f(0.0f, 1.0f, 0.0f), (float)y);
                rawMesh.applyRotation(new Vector3f(0.0f, 0.0f, 1.0f), (float)z);
            });
        }

        @MappedMethod
        public void applyScale(double x, double y, double z) {
            this.rawMeshes.forEach(rawMesh -> rawMesh.applyScale((float)x, (float)y, (float)z));
        }

        @MappedMethod
        public void applyMirror(boolean x, boolean y, boolean z) {
            this.rawMeshes.forEach(rawMesh -> rawMesh.applyMirror(x, y, z, x, y, z));
        }

        @MappedMethod
        public float getMinX() {
            return this.minX;
        }

        @MappedMethod
        public float getMinY() {
            return this.minY;
        }

        @MappedMethod
        public float getMinZ() {
            return this.minZ;
        }

        @MappedMethod
        public float getMaxX() {
            return this.maxX;
        }

        @MappedMethod
        public float getMaxY() {
            return this.maxY;
        }

        @MappedMethod
        public float getMaxZ() {
            return this.maxZ;
        }
    }

    public static final class MaterialGroup {
        private final MaterialProperties materialProperties;
        private final List<Consumer<CapturingVertexConsumer>> modelPartConsumers = new ArrayList<Consumer<CapturingVertexConsumer>>();

        @MappedMethod
        public MaterialGroup(ShaderType shaderType, Identifier texture) {
            this.materialProperties = new MaterialProperties(shaderType, texture, null);
        }

        @MappedMethod
        public void addCube(ModelPartExtension modelPart, double x, double y, double z, boolean flipped, int light) {
            if (modelPart.modelPart != null) {
                this.modelPartConsumers.add(capturingVertexConsumer -> {
                    PoseStack matrixStack = new PoseStack();
                    matrixStack.m_85837_(x, y, z);
                    if (flipped) {
                        matrixStack.m_85845_(com.mojang.math.Vector3f.f_122225_.m_122240_(180.0f));
                    }
                    modelPart.modelPart.m_104301_(matrixStack, (VertexConsumer)capturingVertexConsumer, light, OverlayTexture.getDefaultUvMapped());
                });
            }
        }
    }

    public static enum ShaderType {
        CUTOUT,
        TRANSLUCENT,
        CUTOUT_BRIGHT,
        TRANSLUCENT_BRIGHT,
        CUTOUT_GLOWING,
        TRANSLUCENT_GLOWING;

    }
}

