/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.batch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.object.VertexArray;
import org.mtr.mapping.render.shader.ShaderManager;
import org.mtr.mapping.render.vertex.VertexAttributeState;

public final class BatchManager {
    private final Map<MaterialProperties, List<RenderCall>> opaqueBatches = new HashMap<MaterialProperties, List<RenderCall>>();
    private final Map<MaterialProperties, List<RenderCall>> cutoutBatches = new HashMap<MaterialProperties, List<RenderCall>>();
    private final Map<MaterialProperties, List<RenderCall>> translucentBatches = new HashMap<MaterialProperties, List<RenderCall>>();

    public void queue(List<VertexArray> vertexArrays, VertexAttributeState vertexAttributeState) {
        vertexArrays.forEach(vertexArray -> this.queue((VertexArray)vertexArray, vertexAttributeState));
    }

    public void queue(VertexArray vertexArray, VertexAttributeState vertexAttributeState) {
        MaterialProperties materialProperties = vertexArray.materialProperties;
        (materialProperties.translucent ? this.translucentBatches : (materialProperties.cutoutHack ? this.cutoutBatches : this.opaqueBatches)).computeIfAbsent(materialProperties, key -> new ArrayList()).add(new RenderCall(vertexArray, vertexAttributeState));
    }

    public void drawAll(ShaderManager shaderManager, boolean renderTranslucent) {
        BatchManager.drawBatch(this.opaqueBatches, shaderManager);
        BatchManager.drawBatch(this.cutoutBatches, shaderManager);
        if (renderTranslucent) {
            BatchManager.drawBatch(this.translucentBatches, shaderManager);
        }
    }

    private static void drawBatch(Map<MaterialProperties, List<RenderCall>> batches, ShaderManager shaderManager) {
        batches.forEach((materialProperties, renderCalls) -> {
            shaderManager.setupShaderBatchState((MaterialProperties)materialProperties);
            renderCalls.forEach(RenderCall::draw);
            shaderManager.cleanupShaderBatchState();
        });
        batches.clear();
    }

    private static class RenderCall {
        public final VertexArray vertexArray;
        public final VertexAttributeState vertexAttributeState;

        public RenderCall(VertexArray vertexArray, VertexAttributeState vertexAttributeState) {
            this.vertexArray = vertexArray;
            this.vertexAttributeState = vertexAttributeState;
        }

        public void draw() {
            this.vertexArray.bind();
            this.vertexAttributeState.apply();
            this.vertexArray.materialProperties.vertexAttributeState.apply();
            this.vertexArray.draw();
        }
    }
}

