/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.vertex;

import java.util.HashMap;
import java.util.Map;
import org.mtr.mapping.render.object.VertexBuffer;
import org.mtr.mapping.render.vertex.VertexAttributeSource;
import org.mtr.mapping.render.vertex.VertexAttributeType;

public final class VertexAttributeMapping {
    public final Map<VertexAttributeType, VertexAttributeSource> sources;
    public final Map<VertexAttributeType, Integer> pointers = new HashMap<VertexAttributeType, Integer>();
    public final int strideVertex;
    public final int strideInstance;
    public final int paddingVertex;
    public final int paddingInstance;

    private VertexAttributeMapping(Map<VertexAttributeType, VertexAttributeSource> sources) {
        this.sources = sources;
        int strideVertex = 0;
        int strideInstance = 0;
        block4: for (VertexAttributeType vertexAttributeType : VertexAttributeType.values()) {
            switch (sources.get((Object)vertexAttributeType)) {
                case VERTEX_BUFFER: {
                    this.pointers.put(vertexAttributeType, strideVertex);
                    strideVertex += vertexAttributeType.byteSize;
                    continue block4;
                }
                case INSTANCE_BUFFER: {
                    this.pointers.put(vertexAttributeType, strideInstance);
                    strideInstance += vertexAttributeType.byteSize;
                }
            }
        }
        if (strideVertex % 2 != 0) {
            ++strideVertex;
            this.paddingVertex = 1;
        } else {
            this.paddingVertex = 0;
        }
        if (strideInstance % 2 != 0) {
            ++strideInstance;
            this.paddingInstance = 1;
        } else {
            this.paddingInstance = 0;
        }
        this.strideVertex = strideVertex;
        this.strideInstance = strideInstance;
    }

    public void setupAttributesToVao(VertexBuffer vertexBuf) {
        block4: for (VertexAttributeType vertexAttributeType : VertexAttributeType.values()) {
            switch (this.sources.get((Object)vertexAttributeType)) {
                case GLOBAL: {
                    vertexAttributeType.toggleAttributeArray(false);
                    continue block4;
                }
                case VERTEX_BUFFER: {
                    vertexAttributeType.toggleAttributeArray(true);
                    vertexBuf.bind(34962);
                    vertexAttributeType.setupAttributePointer(this.strideVertex, this.pointers.get((Object)vertexAttributeType));
                    vertexAttributeType.setAttributeDivisor(0);
                }
            }
        }
    }

    public static class Builder {
        private final HashMap<VertexAttributeType, VertexAttributeSource> sources = new HashMap(VertexAttributeType.values().length);

        public Builder() {
            for (VertexAttributeType vertexAttributeType : VertexAttributeType.values()) {
                this.sources.put(vertexAttributeType, VertexAttributeSource.VERTEX_BUFFER);
            }
        }

        public Builder set(VertexAttributeType vertexAttributeType, VertexAttributeSource vertexAttributeSource) {
            this.sources.put(vertexAttributeType, vertexAttributeSource);
            return this;
        }

        public VertexAttributeMapping build() {
            return new VertexAttributeMapping(this.sources);
        }
    }
}

