/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;

public final class ResourcePackHelper {
    private static final String PACK_MCMETA_FILE = "pack.mcmeta";
    private static final String CUSTOM_RESOURCES_FILE = String.format("assets/mtr/%s.json", "mtr_custom_resources");
    private static final String NTE_FOLDER = "assets/mtrsteamloco";
    private static final int PACK_VERSION = ResourceManagerHelper.getResourcePackVersion();

    public static void fix() {
        long startTime = System.currentTimeMillis();
        try (Stream<Path> stream = Files.list(MinecraftClient.getInstance().getRunDirectoryMapped().toPath().resolve("resourcepacks"));){
            stream.forEach(path -> {
                block21: {
                    try {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            byte[] newPackContent;
                            if ((Files.exists(path.resolve(CUSTOM_RESOURCES_FILE), new LinkOption[0]) || Files.isDirectory(path.resolve(NTE_FOLDER), new LinkOption[0])) && (newPackContent = ResourcePackHelper.modifyPackFile(FileUtils.readFileToString((File)path.resolve(PACK_MCMETA_FILE).toFile(), (Charset)StandardCharsets.UTF_8))) != null) {
                                Files.write(path.resolve(PACK_MCMETA_FILE), newPackContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            }
                            break block21;
                        }
                        boolean[] isValidResourcePack = new boolean[]{false};
                        byte[][] newPackContent = new byte[][]{null};
                        try (ZipFile zipFile = new ZipFile(path.toFile());
                             Stream<? extends ZipEntry> zipStream = zipFile.stream();){
                            zipStream.forEach(entry -> {
                                if (entry.getName().equals(PACK_MCMETA_FILE)) {
                                    try (InputStream inputStream2 = zipFile.getInputStream((ZipEntry)entry);){
                                        newPackContent[0] = ResourcePackHelper.modifyPackFile(IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8));
                                    }
                                    catch (Exception e) {
                                        Init.LOGGER.error("", (Throwable)e);
                                    }
                                } else if (entry.getName().equals(CUSTOM_RESOURCES_FILE) || entry.getName().equals(NTE_FOLDER)) {
                                    isValidResourcePack[0] = true;
                                }
                            });
                        }
                        if (!isValidResourcePack[0] || newPackContent[0] == null) break block21;
                        try (FileSystem fileSystem2 = FileSystems.newFileSystem(URI.create("jar:" + path.toUri()), Collections.singletonMap("create", "true"));){
                            Files.write(fileSystem2.getPath(PACK_MCMETA_FILE, new String[0]), newPackContent[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        }
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
        Init.LOGGER.info("Resource pack version check completed in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    @Nullable
    private static byte[] modifyPackFile(String content) {
        try {
            JsonObject jsonObject = JsonParser.parseString(content).getAsJsonObject();
            jsonObject.getAsJsonObject("pack").addProperty("pack_format", PACK_VERSION);
            return Utilities.prettyPrint(jsonObject).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }
}

