/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import javax.annotation.Nonnull;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemConvertible;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;

public abstract class BlockEscalatorBase
extends BlockExtension
implements IBlock,
DirectionHelper {
    public static final EnumProperty<EnumEscalatorOrientation> ORIENTATION = EnumProperty.of("orientation", EnumEscalatorOrientation.class);

    protected BlockEscalatorBase() {
        super(BlockHelper.createBlockSettings(true).nonOpaque());
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (this.getSideDirection(state) == direction && !neighborState.isOf(new Block(this))) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return state.with(new org.mtr.mapping.holder.Property((Property)BlockEscalatorBase.ORIENTATION.data), this.getOrientation(BlockView.cast(world), pos, state));
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return super.getOutlineShape2(state, world, pos, context);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        EnumEscalatorOrientation orientation = this.getOrientation(world, pos, state);
        if (orientation == EnumEscalatorOrientation.SLOPE || orientation == EnumEscalatorOrientation.TRANSITION_TOP) {
            return VoxelShapes.union(Block.createCuboidShape(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), IBlock.getVoxelShapeByDirection(0.0, 8.0, 0.0, 16.0, 15.0, 8.0, IBlock.getStatePropertySafe(state, FACING)));
        }
        return VoxelShapes.fullCube();
    }

    @Override
    @Nonnull
    public Item asItem2() {
        return Items.ESCALATOR.get();
    }

    @Override
    @Nonnull
    public ItemStack getPickStack2(BlockView world, BlockPos pos, BlockState state) {
        return new ItemStack(new ItemConvertible((ItemLike)this.asItem2().data));
    }

    protected final EnumEscalatorOrientation getOrientation(BlockView world, BlockPos pos, BlockState state) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockPos posAhead = pos.offset(facing);
        BlockPos posBehind = pos.offset(facing, -1);
        boolean isAhead = state.isOf(world.getBlockState(posAhead).getBlock());
        boolean isAheadUp = state.isOf(world.getBlockState(posAhead.up()).getBlock());
        boolean isBehind = state.isOf(world.getBlockState(posBehind).getBlock());
        boolean isBehindDown = state.isOf(world.getBlockState(posBehind.down()).getBlock());
        if (isAhead && isBehind) {
            return EnumEscalatorOrientation.FLAT;
        }
        if (isAheadUp && isBehindDown) {
            return EnumEscalatorOrientation.SLOPE;
        }
        if (isAheadUp && isBehind) {
            return EnumEscalatorOrientation.TRANSITION_BOTTOM;
        }
        if (isAhead && isBehindDown) {
            return EnumEscalatorOrientation.TRANSITION_TOP;
        }
        if (isBehind) {
            return EnumEscalatorOrientation.LANDING_TOP;
        }
        return EnumEscalatorOrientation.LANDING_BOTTOM;
    }

    @Override
    private Direction getSideDirection(BlockState state) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        return IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT ? facing.rotateYCounterclockwise() : facing.rotateYClockwise();
    }

    public static enum EnumEscalatorOrientation implements StringIdentifiable
    {
        LANDING_BOTTOM("landing_bottom"),
        LANDING_TOP("landing_top"),
        FLAT("flat"),
        SLOPE("slope"),
        TRANSITION_BOTTOM("transition_bottom"),
        TRANSITION_TOP("transition_top");

        private final String name;

        private EnumEscalatorOrientation(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

