/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.packet.PacketOpenPIDSConfigScreen;

public abstract class BlockPIDSBase
extends BlockExtension
implements DirectionHelper,
BlockWithEntity {
    public final int maxArrivals;
    public final BiPredicate<World, BlockPos> canStoreData;
    public final BiFunction<World, BlockPos, BlockPos> getBlockPosWithData;

    public BlockPIDSBase(int maxArrivals, BiPredicate<World, BlockPos> canStoreData, BiFunction<World, BlockPos, BlockPos> getBlockPosWithData) {
        super(BlockHelper.createBlockSettings(true, blockState -> 5).nonOpaque());
        this.maxArrivals = maxArrivals;
        this.canStoreData = canStoreData;
        this.getBlockPosWithData = getBlockPosWithData;
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockPos newBlockPos = this.getBlockPosWithData.apply(world, pos);
            BlockEntity entity = world.getBlockEntity(newBlockPos);
            if (entity != null && entity.data instanceof BlockEntityBase) {
                ((BlockEntityBase)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenPIDSConfigScreen(newBlockPos, ((BlockEntityBase)((Object)((Object)entity.data))).maxArrivals));
            }
        });
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        public final int maxArrivals;
        public final BiPredicate<World, BlockPos> canStoreData;
        public final BiFunction<World, BlockPos, BlockPos> getBlockPosWithData;
        private final String[] messages;
        private final boolean[] hideArrivalArray;
        private final LongAVLTreeSet platformIds = new LongAVLTreeSet();
        private int displayPage;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_HIDE_ARRIVAL = "hide_arrival";
        private static final String KEY_PLATFORM_IDS = "platform_ids";
        private static final String KEY_DISPLAY_PAGE = "display_page";

        public BlockEntityBase(int maxArrivals, BiPredicate<World, BlockPos> canStoreData, BiFunction<World, BlockPos, BlockPos> getBlockPosWithData, BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
            this.maxArrivals = maxArrivals;
            this.canStoreData = canStoreData;
            this.getBlockPosWithData = getBlockPosWithData;
            this.messages = new String[maxArrivals];
            for (int i = 0; i < maxArrivals; ++i) {
                this.messages[i] = "";
            }
            this.hideArrivalArray = new boolean[maxArrivals];
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long[] platformIdsArray;
            for (int i = 0; i < this.maxArrivals; ++i) {
                this.messages[i] = compoundTag.getString(KEY_MESSAGE + i);
                this.hideArrivalArray[i] = compoundTag.getBoolean(KEY_HIDE_ARRIVAL + i);
            }
            this.platformIds.clear();
            for (long platformId : platformIdsArray = compoundTag.getLongArray(KEY_PLATFORM_IDS)) {
                this.platformIds.add(platformId);
            }
            this.displayPage = compoundTag.getInt(KEY_DISPLAY_PAGE);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < this.maxArrivals; ++i) {
                compoundTag.putString(KEY_MESSAGE + i, this.messages[i] == null ? "" : this.messages[i]);
                compoundTag.putBoolean(KEY_HIDE_ARRIVAL + i, this.hideArrivalArray[i]);
            }
            compoundTag.putLongArray(KEY_PLATFORM_IDS, new ArrayList<Long>(this.platformIds));
            compoundTag.putInt(KEY_DISPLAY_PAGE, this.displayPage);
        }

        public void setData(String[] messages, boolean[] hideArrivalArray, LongAVLTreeSet platformIds, int displayPage) {
            System.arraycopy(messages, 0, this.messages, 0, Math.min(messages.length, this.messages.length));
            System.arraycopy(hideArrivalArray, 0, this.hideArrivalArray, 0, Math.min(hideArrivalArray.length, this.hideArrivalArray.length));
            this.platformIds.clear();
            this.platformIds.addAll(platformIds);
            this.displayPage = displayPage;
            this.markDirty2();
        }

        public int getDisplayPage() {
            return this.displayPage;
        }

        public LongAVLTreeSet getPlatformIds() {
            return this.platformIds;
        }

        public String getMessage(int index) {
            if (index >= 0 && index < this.maxArrivals) {
                if (this.messages[index] == null) {
                    this.messages[index] = "";
                }
                return this.messages[index];
            }
            return "";
        }

        public boolean getHideArrival(int index) {
            if (index >= 0 && index < this.maxArrivals) {
                return this.hideArrivalArray[index];
            }
            return false;
        }

        public abstract boolean showArrivalNumber();

        public abstract boolean alternateLines();

        public abstract int textColorArrived();

        public abstract int textColor();
    }
}

