/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockDirectionalDoubleBlockBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;

public abstract class BlockRouteSignBase
extends BlockDirectionalDoubleBlockBase
implements IBlock,
BlockWithEntity {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.of("propagate_property", 0, 3);

    public BlockRouteSignBase() {
        super(BlockHelper.createBlockSettings(true, blockState -> 15));
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        double y = hit.getPos().getYMapped();
        boolean isUpper = IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER;
        return IBlock.checkHoldingBrush(world, player, () -> {
            if (isUpper && y - Math.floor(y) > 0.8125) {
                world.setBlockState(pos, state.cycle(new org.mtr.mapping.holder.Property((Property)BlockRouteSignBase.ARROW_DIRECTION.data)));
                this.propagate(world, pos, Direction.DOWN, new org.mtr.mapping.holder.Property((Property)BlockRouteSignBase.ARROW_DIRECTION.data), 1);
            } else {
                BlockEntity entity = world.getBlockEntity(pos.down(isUpper ? 1 : 0));
                if (entity != null && entity.data instanceof BlockEntityBase) {
                    Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenBlockEntityScreen(entity.getPos()));
                }
            }
        });
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(ARROW_DIRECTION);
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        private long platformId;
        private static final String KEY_PLATFORM_ID = "platform_id";

        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.platformId = compoundTag.getLong(KEY_PLATFORM_ID);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLong(KEY_PLATFORM_ID, this.platformId);
        }

        public void setPlatformId(long platformId) {
            this.platformId = platformId;
            this.markDirty2();
        }

        public long getPlatformId() {
            return this.platformId;
        }
    }
}

