/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.block.BlockDirectionalDoubleBlockBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.TicketSystem;

public class BlockTicketProcessor
extends BlockDirectionalDoubleBlockBase {
    public final boolean hasLight;
    public final boolean canEnter;
    public final boolean canExit;
    public static final EnumProperty<EnumTicketProcessorLights> LIGHTS = EnumProperty.of("lights", EnumTicketProcessorLights.class);

    public BlockTicketProcessor(boolean hasLight, boolean canEnter, boolean canExit) {
        super(BlockHelper.createBlockSettings(true, blockState -> 5));
        this.hasLight = hasLight;
        this.canEnter = canEnter;
        this.canExit = canExit;
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (!world.isClient() && IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            BlockPos blockPosCopy = new BlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            TicketSystem.passThrough(world, blockPosCopy, player, this.canEnter, this.canExit, SoundEvents.TICKET_PROCESSOR_ENTRY.get(), SoundEvents.TICKET_PROCESSOR_ENTRY_CONCESSIONARY.get(), SoundEvents.TICKET_PROCESSOR_EXIT.get(), SoundEvents.TICKET_PROCESSOR_EXIT_CONCESSIONARY.get(), SoundEvents.TICKET_PROCESSOR_FAIL.get(), true, open -> world.setBlockState(blockPosCopy, state.with(new org.mtr.mapping.holder.Property((Property)BlockTicketProcessor.LIGHTS.data), open == TicketSystem.EnumTicketBarrierOpen.CLOSED ? EnumTicketProcessorLights.RED : EnumTicketProcessorLights.GREEN)));
            BlockTicketProcessor.scheduleBlockTick(world, blockPosCopy, new Block(this), 20);
        }
        return ActionResult.SUCCESS;
    }

    @Override
    public void scheduledTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (this.hasLight) {
            world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)BlockTicketProcessor.LIGHTS.data), EnumTicketProcessorLights.NONE));
        }
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            return VoxelShapes.union(IBlock.getVoxelShapeByDirection(4.75, 1.0, 0.0, 11.25, 13.0, 8.0, facing), IBlock.getVoxelShapeByDirection(7.0, 0.0, 2.0, 9.0, 1.0, 4.0, facing));
        }
        return VoxelShapes.union(IBlock.getVoxelShapeByDirection(5.0, 0.0, 0.0, 11.0, 1.0, 6.0, facing), IBlock.getVoxelShapeByDirection(7.0, 1.0, 2.0, 9.0, 16.0, 4.0, facing));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(LIGHTS);
    }

    public static enum EnumTicketProcessorLights implements StringIdentifiable
    {
        NONE("none"),
        RED("red"),
        YELLOW_GREEN("yellow_green"),
        GREEN("green");

        private final String name;

        private EnumTicketProcessorLights(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

