/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.block.BlockTrainSensorBase;

public class BlockTrainAnnouncer
extends BlockTrainSensorBase {
    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockTrainSensorBase.BlockEntityBase {
        private String message = "";
        private String soundId = "";
        private long lastAnnouncedMillis;
        private static final int ANNOUNCE_COOL_DOWN_MILLIS = 20000;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_SOUND_ID = "sound_id";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.TRAIN_ANNOUNCER.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.message = compoundTag.getString(KEY_MESSAGE);
            this.soundId = compoundTag.getString(KEY_SOUND_ID);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putString(KEY_MESSAGE, this.message);
            compoundTag.putString(KEY_SOUND_ID, this.soundId);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly, String message, String soundId) {
            this.message = message;
            this.soundId = soundId;
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public String getMessage() {
            return this.message;
        }

        public String getSoundId() {
            return this.soundId;
        }

        public void announce(Consumer<String> messageConsumer, Consumer<String> soundIdConsumer) {
            long currentMillis = System.currentTimeMillis();
            if (currentMillis - this.lastAnnouncedMillis >= 20000L) {
                if (!this.message.isEmpty()) {
                    messageConsumer.accept(this.message);
                }
                if (!this.soundId.isEmpty()) {
                    soundIdConsumer.accept(this.soundId);
                }
                this.lastAnnouncedMillis = System.currentTimeMillis();
            }
        }
    }
}

