/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.ClientData;
import org.mtr.core.data.Data;
import org.mtr.core.data.Lift;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.Position;
import org.mtr.core.data.Rail;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayNetworkHandler;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.GameMode;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerListEntry;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.KeyBindings;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.data.PersistentVehicleData;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.packet.PacketDriveTrain;
import org.mtr.mod.screen.DashboardListItem;

public final class MinecraftClientData
extends ClientData {
    public final ObjectArraySet<VehicleExtension> vehicles = new ObjectArraySet();
    public final Long2ObjectAVLTreeMap<PersistentVehicleData> vehicleIdToPersistentVehicleData = new Long2ObjectAVLTreeMap();
    public final Long2ObjectAVLTreeMap<LiftWrapper> liftWrapperList = new Long2ObjectAVLTreeMap();
    public final Object2ObjectArrayMap<String, RailWrapper> railWrapperList = new Object2ObjectArrayMap();
    public final Object2ObjectAVLTreeMap<String, LongArrayList> railIdToBlockedSignalColors = new Object2ObjectAVLTreeMap();
    public final ObjectArrayList<DashboardListItem> railActions = new ObjectArrayList();
    private static MinecraftClientData instance = new MinecraftClientData();
    private static MinecraftClientData dashboardInstance = new MinecraftClientData();
    public static String DASHBOARD_SEARCH = "";
    public static String ROUTES_PLATFORMS_SEARCH = "";
    public static String ROUTES_PLATFORMS_SELECTED_SEARCH = "";
    public static String TRAINS_SEARCH = "";
    public static String EXIT_PARENTS_SEARCH = "";
    public static String EXIT_DESTINATIONS_SEARCH = "";
    private static boolean pressingAccelerate = false;
    private static boolean pressingBrake = false;
    private static boolean pressingDoors = false;

    @Override
    public void sync() {
        super.sync();
        MinecraftClientData.checkAndRemoveFromMap(this.vehicleIdToPersistentVehicleData, this.vehicles, NameColorDataBase::getId);
        MinecraftClientData.checkAndRemoveFromMap(this.liftWrapperList, this.lifts, NameColorDataBase::getId);
        this.lifts.forEach(lift -> {
            LiftWrapper liftWrapper = this.liftWrapperList.get(lift.getId());
            if (liftWrapper == null) {
                this.liftWrapperList.put(lift.getId(), new LiftWrapper((Lift)lift));
            } else {
                liftWrapper.lift = lift;
            }
        });
        MinecraftClientData.checkAndRemoveFromMap(this.railWrapperList, this.rails, TwoPositionsBase::getHexId);
        this.positionsToRail.forEach((startPosition, railMap) -> railMap.forEach((endPosition, rail) -> {
            String hexId = rail.getHexId();
            RailWrapper railWrapper = this.railWrapperList.get(hexId);
            if (railWrapper == null) {
                this.railWrapperList.put(hexId, new RailWrapper((Rail)rail, hexId, (Position)startPosition, (Position)endPosition));
            } else {
                railWrapper.rail = rail;
            }
        }));
    }

    @Nullable
    public Rail getFacingRail(boolean includeCableType) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        if (clientWorld == null) {
            return null;
        }
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientPlayerEntity == null) {
            return null;
        }
        HitResult hitResult = minecraftClient.getCrosshairTargetMapped();
        if (hitResult == null) {
            return null;
        }
        Vector3d hitPos = hitResult.getPos();
        BlockPos blockPos = Init.newBlockPos(hitPos.getXMapped(), hitPos.getYMapped(), hitPos.getZMapped());
        if (clientWorld.getBlockState((BlockPos)blockPos).getBlock().data instanceof BlockNode) {
            float playerAngle = EntityHelper.getYaw(new Entity((net.minecraft.world.entity.Entity)clientPlayerEntity.data)) + 90.0f;
            Rail[] closestRail = new Rail[]{null};
            double[] closestAngle = new double[]{720.0};
            this.positionsToRail.getOrDefault(Init.blockPosToPosition(blockPos), new Object2ObjectOpenHashMap()).forEach((endPosition, rail) -> {
                if (includeCableType || rail.railMath.getShape() != Rail.Shape.CABLE) {
                    double clampedAngle;
                    double angle = Math.abs(Math.toDegrees(Math.atan2(endPosition.getZ() - (long)blockPos.getZ(), endPosition.getX() - (long)blockPos.getX())) - (double)playerAngle) % 360.0;
                    double d = clampedAngle = angle > 180.0 ? 360.0 - angle : angle;
                    if (clampedAngle < closestAngle[0]) {
                        closestRail[0] = rail;
                        closestAngle[0] = clampedAngle;
                    }
                }
            });
            return closestRail[0];
        }
        return null;
    }

    public static MinecraftClientData getInstance() {
        return instance;
    }

    public static MinecraftClientData getDashboardInstance() {
        return dashboardInstance;
    }

    public static void reset() {
        instance = new MinecraftClientData();
        dashboardInstance = new MinecraftClientData();
    }

    public static void tick() {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        boolean tempPressingAccelerate = KeyBindings.TRAIN_ACCELERATE.isPressed();
        boolean tempPressingBrake = KeyBindings.TRAIN_BRAKE.isPressed();
        boolean tempPressingDoors = KeyBindings.TRAIN_TOGGLE_DOORS.isPressed();
        if (VehicleExtension.isHoldingKey(clientPlayerEntity) && (pressingAccelerate || pressingBrake || pressingDoors)) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDriveTrain(tempPressingAccelerate && !pressingAccelerate, tempPressingBrake && !pressingBrake, tempPressingDoors && !pressingDoors));
        }
        pressingAccelerate = tempPressingAccelerate;
        pressingBrake = tempPressingBrake;
        pressingDoors = tempPressingDoors;
    }

    public static boolean hasPermission() {
        ClientPlayerEntity player = MinecraftClient.getInstance().getPlayerMapped();
        if (player == null) {
            return false;
        }
        ClientPlayNetworkHandler clientPlayNetworkHandler = MinecraftClient.getInstance().getNetworkHandler();
        if (clientPlayNetworkHandler == null) {
            return false;
        }
        PlayerListEntry playerListEntry = clientPlayNetworkHandler.getPlayerListEntry(player.getUuid());
        if (playerListEntry == null) {
            return false;
        }
        GameMode gameMode = playerListEntry.getGameMode();
        return gameMode == GameMode.getCreativeMapped() || gameMode == GameMode.getSurvivalMapped();
    }

    @Nullable
    public static Lift getLift(long liftId) {
        for (Lift lift : MinecraftClientData.getInstance().lifts) {
            if (lift.getId() != liftId) continue;
            return lift;
        }
        return null;
    }

    public static <T extends NameColorDataBase> ObjectArraySet<DashboardListItem> getFilteredDataSet(TransportMode transportMode, ObjectArraySet<T> dataSet) {
        return MinecraftClientData.convertDataSet(dataSet.stream().filter(data -> data.isTransportMode(transportMode)).collect(Collectors.toCollection(ObjectArraySet::new)));
    }

    public static <T extends NameColorDataBase> ObjectArraySet<DashboardListItem> convertDataSet(ObjectArraySet<T> dataSet) {
        return dataSet.stream().map(DashboardListItem::new).collect(Collectors.toCollection(ObjectArraySet::new));
    }

    public static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> Object2ObjectAVLTreeMap<Position, ObjectArrayList<U>> getFlatPositionToSavedRails(ObjectArraySet<U> savedRails, TransportMode transportMode) {
        Object2ObjectAVLTreeMap map = new Object2ObjectAVLTreeMap();
        savedRails.forEach(savedRail -> {
            if (savedRail.isTransportMode(transportMode)) {
                Position position = savedRail.getMidPosition();
                Data.put(map, new Position(position.getX(), 0L, position.getZ()), savedRail, ObjectArrayList::new);
            }
        });
        map.forEach((position, newSavedRails) -> newSavedRails.sort((savedRail1, savedRail2) -> {
            long y2;
            if (savedRail1.getId() == savedRail2.getId()) {
                return 0;
            }
            long y1 = savedRail1.getMidPosition().getY();
            return y1 == (y2 = savedRail2.getMidPosition().getY()) ? (savedRail1.getId() > savedRail2.getId() ? 1 : -1) : (y1 > y2 ? 1 : -1);
        }));
        return map;
    }

    private static <T, U, V> void checkAndRemoveFromMap(Map<T, U> map, ObjectSet<V> dataSet, Function<V, T> getId) {
        ObjectAVLTreeSet idSet = dataSet.stream().map(getId).collect(Collectors.toCollection(ObjectAVLTreeSet::new));
        ObjectArrayList<Object> idsToRemove = new ObjectArrayList<Object>();
        map.keySet().forEach(id -> {
            if (!idSet.contains(id)) {
                idsToRemove.add(id);
            }
        });
        idsToRemove.forEach(map::remove);
    }

    public static class RailWrapper {
        public boolean shouldRender;
        public final String hexId;
        public final Vec3d startVector;
        public final Vec3d endVector;
        private Rail rail;

        private RailWrapper(Rail rail, String hexId, Position startPosition, Position endPosition) {
            this.rail = rail;
            this.hexId = hexId;
            this.startVector = new Vec3d(Math.min(startPosition.getX(), endPosition.getX()), Math.min(startPosition.getY(), endPosition.getY()), Math.min(startPosition.getZ(), endPosition.getZ()));
            this.endVector = new Vec3d(Math.max(startPosition.getX(), endPosition.getX()), Math.max(startPosition.getY(), endPosition.getY()), Math.max(startPosition.getZ(), endPosition.getZ()));
        }

        public Rail getRail() {
            return this.rail;
        }
    }

    public static class LiftWrapper {
        public boolean shouldRender;
        private Lift lift;

        private LiftWrapper(Lift lift) {
            this.lift = lift;
        }

        public Lift getLift() {
            return this.lift;
        }
    }
}

