/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectBooleanImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.KeyBindings;
import org.mtr.mod.client.GangwayMovementPositions;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateVehicleRidingEntities;
import org.mtr.mod.render.RenderVehicleHelper;
import org.mtr.mod.render.RenderVehicleTransformationHelper;
import org.mtr.mod.screen.LiftSelectionScreen;

public class VehicleRidingMovement {
    private static long ridingSidingId;
    private static long ridingVehicleId;
    private static int ridingVehicleCarNumber;
    private static double ridingVehicleX;
    private static double ridingVehicleY;
    private static double ridingVehicleZ;
    private static boolean isOnGangway;
    private static int ridingVehicleCoolDown;
    private static float shiftHoldingTicks;
    private static int ridingVehicleCarNumberCacheOld;
    private static Vector3d ridingPositionCacheOld;
    private static Vector3d ridingPositionCache;
    private static Double ridingYawDifferenceOld;
    private static Double ridingYawDifference;
    private static double previousVehicleYaw;
    private static long sendPositionUpdateTime;
    private static final float VEHICLE_WALKING_SPEED_MULTIPLIER = 0.005f;
    private static final int RIDING_COOL_DOWN = 5;
    private static final int SEND_UPDATE_FREQUENCY = 1000;
    private static final int SHIFT_ACTIVATE_TICKS = 30;
    private static final int DISMOUNT_PROGRESS_BAR_LENGTH = 30;

    public static void tick() {
        if (ridingVehicleCoolDown < 5 && shiftHoldingTicks < 30.0f) {
            ++ridingVehicleCoolDown;
        } else {
            VehicleRidingMovement.sendUpdate(true);
            ridingSidingId = 0L;
            ridingVehicleId = 0L;
        }
        if (ridingPositionCache != null) {
            ridingVehicleCarNumberCacheOld = ridingVehicleCarNumber;
            ridingPositionCacheOld = ridingPositionCache;
            ridingYawDifferenceOld = ridingYawDifference;
        }
        if (sendPositionUpdateTime > 0L && sendPositionUpdateTime <= System.currentTimeMillis()) {
            VehicleRidingMovement.sendUpdate(false);
        }
        if (ridingVehicleId == 0L) {
            shiftHoldingTicks = 0.0f;
        } else {
            ClientPlayerEntity clientPlayerEntity;
            MinecraftClient minecraftClient = MinecraftClient.getInstance();
            if (KeyBindings.LIFT_MENU.isPressed()) {
                Screen currentScreen = minecraftClient.getCurrentScreenMapped();
                if (!(MinecraftClientData.getLift(ridingVehicleId) == null || currentScreen != null && currentScreen.data instanceof LiftSelectionScreen)) {
                    minecraftClient.openScreen(new Screen(new LiftSelectionScreen(ridingVehicleId)));
                }
            }
            shiftHoldingTicks = (clientPlayerEntity = minecraftClient.getPlayerMapped()) != null && clientPlayerEntity.isSneaking() ? (shiftHoldingTicks += minecraftClient.getLastFrameDuration()) : 0.0f;
        }
    }

    public static void startRiding(ObjectArrayList<Box> openDoorways, long sidingId, long vehicleId, int carNumber, double x, double y, double z, double yaw) {
        if (ridingVehicleId == 0L || VehicleRidingMovement.isRiding(vehicleId)) {
            for (Box doorway : openDoorways) {
                if (!RenderVehicleHelper.boxContains(doorway, x, y, z)) continue;
                ridingSidingId = sidingId;
                ridingVehicleId = vehicleId;
                ridingVehicleCarNumber = carNumber;
                ridingVehicleX = x;
                ridingVehicleY = y;
                ridingVehicleZ = z;
                isOnGangway = false;
                ridingPositionCacheOld = null;
                ridingPositionCache = null;
                ridingYawDifferenceOld = null;
                ridingYawDifference = null;
                previousVehicleYaw = yaw;
                if (ridingVehicleId != 0L) continue;
                VehicleRidingMovement.sendUpdate(false);
            }
        }
    }

    public static void movePlayer(long millisElapsed, long vehicleId, int carNumber, ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsAndDoorways, @Nullable GangwayMovementPositions previousCarGangwayMovementPositions, @Nullable GangwayMovementPositions thisCarGangwayMovementPositions1, @Nullable GangwayMovementPositions thisCarGangwayMovementPositions2, RenderVehicleTransformationHelper renderVehicleTransformationHelper) {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        if (VehicleRidingMovement.isRiding(vehicleId) && ridingVehicleCarNumber == carNumber) {
            ridingVehicleCoolDown = 0;
            double entityYawOld = EntityHelper.getYaw(new Entity((net.minecraft.world.entity.Entity)clientPlayerEntity.data));
            float speedMultiplier = (float)millisElapsed * 0.005f * (float)(clientPlayerEntity.isSprinting() ? 2 : 1);
            Vector3d movement = renderVehicleTransformationHelper.transformBackwards(new Vector3d((double)Math.abs(clientPlayerEntity.getSidewaysSpeedMapped()) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayerEntity.getSidewaysSpeedMapped()) : 0.0, 0.0, (double)Math.abs(clientPlayerEntity.getForwardSpeedMapped()) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayerEntity.getForwardSpeedMapped()) : 0.0), (vector, pitch) -> vector, (vector, yaw) -> vector.rotateY((float)((double)yaw - Math.toRadians(entityYawOld))), (vector, x, y, z) -> vector);
            double movementX = movement.getXMapped();
            double movementZ = movement.getZMapped();
            if (sendPositionUpdateTime == 0L && (movementX != 0.0 || movementZ != 0.0)) {
                sendPositionUpdateTime = System.currentTimeMillis() + 1000L;
            }
            if (isOnGangway) {
                if (thisCarGangwayMovementPositions1 == null || previousCarGangwayMovementPositions == null) {
                    VehicleRidingMovement.sendUpdate(true);
                    ridingSidingId = 0L;
                    ridingVehicleId = 0L;
                } else if (ridingVehicleZ + movementZ > 1.0) {
                    isOnGangway = false;
                    ridingVehicleX = thisCarGangwayMovementPositions1.getX(ridingVehicleX);
                    ridingVehicleZ = thisCarGangwayMovementPositions1.getZ() + ridingVehicleZ + movementZ - 1.0;
                    ridingPositionCache = null;
                } else if (ridingVehicleZ + movementZ < 0.0) {
                    isOnGangway = false;
                    --ridingVehicleCarNumber;
                    ridingVehicleX = previousCarGangwayMovementPositions.getX(ridingVehicleX);
                    ridingVehicleZ = previousCarGangwayMovementPositions.getZ() + ridingVehicleZ + movementZ;
                    ridingPositionCache = null;
                } else {
                    ridingVehicleX = Utilities.clamp(ridingVehicleX + movementX, 0.0, 1.0);
                    Vector3d position1Min = previousCarGangwayMovementPositions.getMinWorldPosition();
                    Vector3d position1Max = previousCarGangwayMovementPositions.getMaxWorldPosition();
                    Vector3d position2Min = thisCarGangwayMovementPositions1.getMinWorldPosition();
                    Vector3d position2Max = thisCarGangwayMovementPositions1.getMaxWorldPosition();
                    double positionX = VehicleRidingMovement.getFromScale(VehicleRidingMovement.getFromScale(position1Min.getXMapped(), position1Max.getXMapped(), ridingVehicleX), VehicleRidingMovement.getFromScale(position2Min.getXMapped(), position2Max.getXMapped(), ridingVehicleX), ridingVehicleZ += movementZ);
                    double positionY = VehicleRidingMovement.getFromScale(VehicleRidingMovement.getFromScale(position1Min.getYMapped(), position1Max.getYMapped(), ridingVehicleX), VehicleRidingMovement.getFromScale(position2Min.getYMapped(), position2Max.getYMapped(), ridingVehicleX), ridingVehicleZ);
                    double positionZ = VehicleRidingMovement.getFromScale(VehicleRidingMovement.getFromScale(position1Min.getZMapped(), position1Max.getZMapped(), ridingVehicleX), VehicleRidingMovement.getFromScale(position2Min.getZMapped(), position2Max.getZMapped(), ridingVehicleX), ridingVehicleZ);
                    ridingPositionCache = renderVehicleTransformationHelper.transformBackwards(new Vector3d(positionX, positionY, positionZ), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
                    VehicleRidingMovement.movePlayer(positionX, positionY, positionZ);
                }
            } else if (thisCarGangwayMovementPositions1 != null && thisCarGangwayMovementPositions1.getPercentageZ(ridingVehicleZ + movementZ) < 1.0) {
                isOnGangway = true;
                ridingVehicleX = thisCarGangwayMovementPositions1.getPercentageX(ridingVehicleX + movementX);
                ridingVehicleZ = thisCarGangwayMovementPositions1.getPercentageZ(ridingVehicleZ + movementZ);
                ridingPositionCache = null;
            } else if (thisCarGangwayMovementPositions2 != null && thisCarGangwayMovementPositions2.getPercentageZ(ridingVehicleZ + movementZ) > 0.0) {
                isOnGangway = true;
                ++ridingVehicleCarNumber;
                ridingVehicleX = thisCarGangwayMovementPositions2.getPercentageX(ridingVehicleX + movementX);
                ridingVehicleZ = thisCarGangwayMovementPositions2.getPercentageZ(ridingVehicleZ + movementZ);
                ridingPositionCache = null;
            } else {
                ObjectArrayList<Vector3d> offsets = new ObjectArrayList<Vector3d>();
                VehicleRidingMovement.clampPosition(floorsAndDoorways, ridingVehicleX + movementX - (double)0.3f, ridingVehicleZ + movementZ - (double)0.3f, offsets);
                VehicleRidingMovement.clampPosition(floorsAndDoorways, ridingVehicleX + movementX + (double)0.3f, ridingVehicleZ + movementZ - (double)0.3f, offsets);
                VehicleRidingMovement.clampPosition(floorsAndDoorways, ridingVehicleX + movementX + (double)0.3f, ridingVehicleZ + movementZ + (double)0.3f, offsets);
                VehicleRidingMovement.clampPosition(floorsAndDoorways, ridingVehicleX + movementX - (double)0.3f, ridingVehicleZ + movementZ + (double)0.3f, offsets);
                if (offsets.isEmpty()) {
                    VehicleRidingMovement.sendUpdate(true);
                    ridingSidingId = 0L;
                    ridingVehicleId = 0L;
                } else {
                    double clampX = 0.0;
                    double maxY = -1.7976931348623157E308;
                    double clampZ = 0.0;
                    for (Vector3d offset : offsets) {
                        if (Math.abs(offset.getXMapped()) > Math.abs(clampX)) {
                            clampX = offset.getXMapped();
                        }
                        maxY = Math.max(maxY, offset.getYMapped());
                        if (!(Math.abs(offset.getZMapped()) > Math.abs(clampZ))) continue;
                        clampZ = offset.getZMapped();
                    }
                    ridingVehicleX += movementX + clampX;
                    ridingVehicleY = maxY;
                    ridingVehicleZ += movementZ + clampZ;
                }
                ridingPositionCache = new Vector3d(ridingVehicleX, ridingVehicleY, ridingVehicleZ);
                Vector3d newPlayerPosition = renderVehicleTransformationHelper.transformForwards(ridingPositionCache, Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
                VehicleRidingMovement.movePlayer(newPlayerPosition.getXMapped(), newPlayerPosition.getYMapped(), newPlayerPosition.getZMapped());
                EntityHelper.setYaw(new Entity((net.minecraft.world.entity.Entity)clientPlayerEntity.data), (float)(Math.toDegrees(previousVehicleYaw - renderVehicleTransformationHelper.yaw) + entityYawOld));
            }
            ridingYawDifference = Math.abs(renderVehicleTransformationHelper.yaw - previousVehicleYaw) > 0.001 ? Double.valueOf(renderVehicleTransformationHelper.yaw + Math.toRadians(entityYawOld)) : null;
            previousVehicleYaw = renderVehicleTransformationHelper.yaw;
        }
    }

    @Nullable
    public static IntObjectImmutablePair<ObjectObjectImmutablePair<Vector3d, Double>> getRidingVehicleCarNumberAndOffset(long vehicleId) {
        return VehicleRidingMovement.isRiding(vehicleId) ? new IntObjectImmutablePair<ObjectObjectImmutablePair<Vector3d, Double>>(ridingVehicleCarNumberCacheOld, new ObjectObjectImmutablePair<Vector3d, Double>(ridingPositionCacheOld, ridingYawDifferenceOld)) : null;
    }

    public static boolean isRiding(long vehicleId) {
        return vehicleId == ridingVehicleId;
    }

    public static boolean showShiftProgressBar() {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (shiftHoldingTicks > 0.0f && clientPlayerEntity != null) {
            int progressFilled = MathHelper.clamp((int)(shiftHoldingTicks * 30.0f / 30.0f), 0, 30);
            String progressBar = String.format("\u00a76%s\u00a77%s", StringUtils.repeat((char)'|', (int)progressFilled), StringUtils.repeat((char)'|', (int)(30 - progressFilled)));
            clientPlayerEntity.sendMessage(new Text((Component)TextHelper.translatable((String)"gui.mtr.dismount_hold", (Object[])new Object[]{minecraftClient.getOptionsMapped().getKeySneakMapped().getBoundKeyLocalizedText().getString(), progressBar}).data), true);
            return false;
        }
        return true;
    }

    public static void writeVehicleId(LongAVLTreeSet keepVehicleIds) {
        if (ridingVehicleId != 0L) {
            keepVehicleIds.add(ridingVehicleId);
        }
    }

    @Nullable
    private static ObjectBooleanImmutablePair<Box> bestPosition(ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsOrDoorways, double x, double y, double z) {
        return floorsOrDoorways.stream().filter(floorOrDoorway -> RenderVehicleHelper.boxContains((Box)floorOrDoorway.left(), x, y, z)).max(Comparator.comparingDouble(floorOrDoorway -> ((Box)floorOrDoorway.left()).getMaxYMapped())).orElse(floorsOrDoorways.stream().filter(floorOrDoorway -> Math.abs(((Box)floorOrDoorway.left()).getMaxYMapped() - ridingVehicleY) <= 1.0).min(Comparator.comparingDouble(floorOrDoorway -> {
            Box box = (Box)floorOrDoorway.left();
            double minX = box.getMinXMapped();
            double maxX = box.getMaxXMapped();
            double minZ = box.getMinZMapped();
            double maxZ = box.getMaxZMapped();
            return (Utilities.isBetween(x, minX, maxX) ? 0.0 : Math.min(Math.abs(minX - x), Math.abs(maxX - x))) + (Utilities.isBetween(z, minZ, maxZ) ? 0.0 : Math.min(Math.abs(minZ - z), Math.abs(maxZ - z)));
        })).orElse(null));
    }

    private static void clampPosition(ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsAndDoorways, double x, double z, ObjectArrayList<Vector3d> offsets) {
        ObjectBooleanImmutablePair<Box> floorOrDoorway = VehicleRidingMovement.bestPosition(floorsAndDoorways, x, ridingVehicleY, z);
        if (floorOrDoorway != null) {
            if (floorOrDoorway.rightBoolean()) {
                offsets.add(new Vector3d(Utilities.clamp(x, floorOrDoorway.left().getMinXMapped(), floorOrDoorway.left().getMaxXMapped()) - x, floorOrDoorway.left().getMaxYMapped(), Utilities.clamp(z, floorOrDoorway.left().getMinZMapped(), floorOrDoorway.left().getMaxZMapped()) - z));
            } else if (RenderVehicleHelper.boxContains(floorOrDoorway.left(), x, ridingVehicleY, z)) {
                offsets.add(new Vector3d(0.0, floorOrDoorway.left().getMaxYMapped(), 0.0));
            }
        }
    }

    private static void movePlayer(double x, double y, double z) {
        if (InitClient.getGameTick() > 40.0f) {
            Runnable runnable2 = () -> {
                MinecraftClient minecraftClient = MinecraftClient.getInstance();
                ClientWorld clientWorld = minecraftClient.getWorldMapped();
                ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
                if (clientPlayerEntity != null && clientWorld != null) {
                    clientPlayerEntity.setFallDistanceMapped(0.0f);
                    clientPlayerEntity.setVelocity(0.0, 0.0, 0.0);
                    clientPlayerEntity.setMovementSpeed(0.0f);
                    clientPlayerEntity.updatePosition(x, y, z);
                }
            };
            runnable2.run();
            InitClient.scheduleMovePlayer(runnable2);
        }
    }

    private static void sendUpdate(boolean dismount) {
        if (ridingSidingId != 0L && ridingVehicleId != 0L) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(PacketUpdateVehicleRidingEntities.create(ridingSidingId, ridingVehicleId, dismount ? -1 : ridingVehicleCarNumber, ridingVehicleX, ridingVehicleY, ridingVehicleZ, isOnGangway));
            sendPositionUpdateTime = 0L;
        }
    }

    private static double getFromScale(double min, double max, double percentage) {
        return (max - min) * percentage + min;
    }
}

