/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.mapper.TextHelper;

public abstract class ItemBlockClickingBase
extends ItemExtension {
    public static final String TAG_POS = "pos";

    public ItemBlockClickingBase(ItemSettings itemSettings) {
        super(itemSettings);
    }

    @Override
    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (!context.getWorld().isClient()) {
            if (this.clickCondition(context)) {
                CompoundTag compoundTag = context.getStack().getOrCreateTag();
                if (compoundTag.contains(TAG_POS)) {
                    BlockPos posEnd = BlockPos.fromLong(compoundTag.getLong(TAG_POS));
                    this.onEndClick(context, posEnd, compoundTag);
                    compoundTag.remove(TAG_POS);
                } else {
                    compoundTag.putLong(TAG_POS, context.getBlockPos().asLong());
                    this.onStartClick(context, compoundTag);
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        long posLong = compoundTag.getLong(TAG_POS);
        if (posLong != 0L) {
            tooltip.add(TextHelper.translatable("tooltip.mtr.selected_block", BlockPos.fromLong(posLong).toShortString()).formatted(TextFormatting.GOLD));
        }
    }

    protected abstract void onStartClick(ItemUsageContext var1, CompoundTag var2);

    protected abstract void onEndClick(ItemUsageContext var1, BlockPos var2, CompoundTag var3);

    protected abstract boolean clickCondition(ItemUsageContext var1);
}

