/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Consumer;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.Position;
import org.mtr.core.data.SavedRailBase;
import org.mtr.init.MTR;
import org.mtr.mod.Init;
import org.mtr.mod.data.IGui;

public interface IUpdateWebMap {
    public static final String MARKER_SET_STATIONS_ID = "mtr_stations";
    public static final String MARKER_SET_STATION_AREAS_ID = "mtr_station_areas";
    public static final String MARKER_SET_STATIONS_TITLE = "Stations";
    public static final String MARKER_SET_STATION_AREAS_TITLE = "Station Areas";
    public static final String MARKER_SET_DEPOTS_ID = "mtr_depots";
    public static final String MARKER_SET_DEPOT_AREAS_ID = "mtr_depot_areas";
    public static final String MARKER_SET_DEPOTS_TITLE = "Depots";
    public static final String MARKER_SET_DEPOT_AREAS_TITLE = "Depot Areas";
    public static final String STATION_ICON_PATH = "/assets/mtr/textures/block/sign/logo.png";
    public static final String DEPOT_ICON_PATH = "/assets/mtr/textures/block/sign/logo_grayscale.png";
    public static final String STATION_ICON_KEY = "mtr_station";
    public static final String DEPOT_ICON_KEY = "mtr_depot";
    public static final int ICON_SIZE = 24;

    public static void readResource(String path, Consumer<InputStream> callback) {
        try (InputStream inputStream2 = MTR.class.getResourceAsStream(path);){
            if (inputStream2 != null) {
                callback.accept(inputStream2);
            }
        }
        catch (IOException e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    public static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> void iterateAreas(Set<T> areas, AreaCallback areaCallback) {
        areas.forEach(area -> {
            int x1 = (int)area.getMinX();
            int z1 = (int)area.getMinZ();
            int x2 = (int)area.getMaxX();
            int z2 = (int)area.getMaxZ();
            Position center = area.getCenter();
            if (center != null) {
                areaCallback.areaCallback(area.getHexId() + "_" + System.currentTimeMillis(), IGui.formatStationName(area.getName()), new Color(area.getColor()), x1, z1, x2, z2, (int)center.getX(), (int)center.getZ());
            }
        });
    }

    @FunctionalInterface
    public static interface AreaCallback {
        public void areaCallback(String var1, String var2, Color var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }
}

