/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import org.mtr.core.data.TransportMode;
import org.mtr.core.integration.Response;
import org.mtr.core.operation.ListDataResponse;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.ClientPacketHelper;
import org.mtr.mod.packet.PacketRequestResponseBase;

public final class PacketOpenDashboardScreen
extends PacketRequestResponseBase {
    private final TransportMode transportMode;

    public PacketOpenDashboardScreen(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packetBufferReceiver.readString());
    }

    private PacketOpenDashboardScreen(String content, TransportMode transportMode) {
        super(content);
        this.transportMode = transportMode;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeString(this.transportMode.toString());
    }

    @Override
    protected void runClientInbound(Response response) {
        response.getData(jsonReader -> new ListDataResponse((ReaderBase)jsonReader, MinecraftClientData.getDashboardInstance())).write();
        ClientPacketHelper.openDashboardScreen(this.transportMode);
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketOpenDashboardScreen(content, this.transportMode);
    }

    @Override
    @Nonnull
    protected String getEndpoint() {
        return "operation/list-data";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.PLAYER;
    }

    public static void sendDirectlyToServer(ServerWorld serverWorld, ServerPlayerEntity serverPlayerEntity, TransportMode transportMode) {
        new PacketOpenDashboardScreen(new JsonObject().toString(), transportMode).runServerOutbound(serverWorld, serverPlayerEntity);
    }
}

