/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.mtr.core.integration.Response;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;

public abstract class PacketRequestResponseBase
extends PacketHandler {
    private final String content;

    public PacketRequestResponseBase(PacketBufferReceiver packetBufferReceiver) {
        this.content = packetBufferReceiver.readString();
    }

    public PacketRequestResponseBase(String content) {
        this.content = content;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.content);
    }

    @Override
    public final void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        this.runServerOutbound(serverPlayerEntity.getServerWorld(), serverPlayerEntity);
    }

    @Override
    public final void runClient() {
        this.runClientInbound(Response.create(Utilities.parseJson(this.content)));
    }

    protected void runServerOutbound(ServerWorld serverWorld, @Nullable ServerPlayerEntity serverPlayerEntity) {
        Init.sendHttpRequest(this.getEndpoint(), new World((Level)serverWorld.data), this.content, this.responseType() == ResponseType.NONE ? null : response -> {
            if (this.responseType() == ResponseType.PLAYER) {
                if (serverPlayerEntity != null) {
                    Init.REGISTRY.sendPacketToClient(serverPlayerEntity, this.getInstance((String)response));
                }
            } else {
                MinecraftServerHelper.iteratePlayers(serverWorld, serverPlayerEntityNew -> Init.REGISTRY.sendPacketToClient((ServerPlayerEntity)serverPlayerEntityNew, this.getInstance((String)response)));
            }
            this.runServerInbound(serverWorld, (String)response);
        });
    }

    protected void runServerInbound(ServerWorld serverWorld, String content) {
    }

    protected void runClientInbound(Response response) {
    }

    protected abstract PacketRequestResponseBase getInstance(String var1);

    @Nonnull
    protected abstract String getEndpoint();

    protected abstract ResponseType responseType();

    protected static enum ResponseType {
        NONE,
        PLAYER,
        ALL;

    }
}

