/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.block.BlockLiftTrackFloor;

public final class PacketUpdateLiftTrackFloorConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final String floorNumber;
    private final String floorDescription;
    private final boolean shouldDing;

    public PacketUpdateLiftTrackFloorConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        this.floorNumber = packetBufferReceiver.readString();
        this.floorDescription = packetBufferReceiver.readString();
        this.shouldDing = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateLiftTrackFloorConfig(BlockPos blockPos, String floorNumber, String floorDescription, boolean shouldDing) {
        this.blockPos = blockPos;
        this.floorNumber = floorNumber;
        this.floorDescription = floorDescription;
        this.shouldDing = shouldDing;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeString(this.floorNumber);
        packetBufferSender.writeString(this.floorDescription);
        packetBufferSender.writeBoolean(this.shouldDing);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockLiftTrackFloor.BlockEntity) {
            ((BlockLiftTrackFloor.BlockEntity)((Object)entity.data)).setData(this.floorNumber, this.floorDescription, this.shouldDing);
        }
    }
}

