/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.block.BlockPIDSBase;

public final class PacketUpdatePIDSConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final String[] messages;
    private final boolean[] hideArrivalArray;
    private final LongAVLTreeSet platformIds;
    private final int displayPage;

    public PacketUpdatePIDSConfig(PacketBufferReceiver packetBufferReceiver) {
        int i;
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        int maxMessages = packetBufferReceiver.readInt();
        this.messages = new String[maxMessages];
        for (i = 0; i < maxMessages; ++i) {
            this.messages[i] = packetBufferReceiver.readString();
        }
        this.hideArrivalArray = new boolean[maxMessages];
        for (i = 0; i < maxMessages; ++i) {
            this.hideArrivalArray[i] = packetBufferReceiver.readBoolean();
        }
        int platformIdCount = packetBufferReceiver.readInt();
        this.platformIds = new LongAVLTreeSet();
        for (int i2 = 0; i2 < platformIdCount; ++i2) {
            this.platformIds.add(packetBufferReceiver.readLong());
        }
        this.displayPage = packetBufferReceiver.readInt();
    }

    public PacketUpdatePIDSConfig(BlockPos blockPos, String[] messages, boolean[] hideArrivalArray, LongAVLTreeSet platformIds, int displayPage) {
        this.blockPos = blockPos;
        this.messages = messages;
        this.hideArrivalArray = hideArrivalArray;
        this.platformIds = platformIds;
        this.displayPage = displayPage;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.messages.length);
        for (String message : this.messages) {
            packetBufferSender.writeString(message);
        }
        for (boolean hideArrival : this.hideArrivalArray) {
            packetBufferSender.writeBoolean(hideArrival);
        }
        packetBufferSender.writeInt(this.platformIds.size());
        this.platformIds.forEach(packetBufferSender::writeLong);
        packetBufferSender.writeInt(this.displayPage);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockPIDSBase.BlockEntityBase) {
            ((BlockPIDSBase.BlockEntityBase)((Object)entity.data)).setData(this.messages, this.hideArrivalArray, this.platformIds, this.displayPage);
        }
    }
}

