/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.block.BlockTrainScheduleSensor;
import org.mtr.mod.packet.PacketUpdateTrainSensorConfig;

public class PacketUpdateTrainScheduleSensorConfig
extends PacketUpdateTrainSensorConfig {
    private final int seconds;
    private final boolean realtimeOnly;

    public PacketUpdateTrainScheduleSensorConfig(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.seconds = packetBufferReceiver.readInt();
        this.realtimeOnly = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateTrainScheduleSensorConfig(BlockPos blockPos, LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly, int seconds, boolean realtimeOnly) {
        super(blockPos, filterRouteIds, stoppedOnly, movingOnly);
        this.seconds = seconds;
        this.realtimeOnly = realtimeOnly;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeInt(this.seconds);
        packetBufferSender.writeBoolean(this.realtimeOnly);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockTrainScheduleSensor.BlockEntity) {
            ((BlockTrainScheduleSensor.BlockEntity)((Object)entity.data)).setData(this.filterRouteIds, this.stoppedOnly, this.movingOnly, this.seconds, this.realtimeOnly);
        }
    }
}

