/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.SavedRailBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.IUpdateWebMap;

public class UpdateDynmap
implements IGui,
IUpdateWebMap {
    private static DynmapCommonAPI dynmapCommonAPI;

    public static void updateDynmap(World world) {
        try {
            UpdateDynmap.updateDynmap(world, MinecraftClientData.getInstance().stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "mtr_station");
            UpdateDynmap.updateDynmap(world, MinecraftClientData.getInstance().depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "mtr_depot");
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    private static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> void updateDynmap(World world, ObjectArraySet<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        if (dynmapCommonAPI != null) {
            String worldId = switch (MinecraftServerHelper.getWorldId(world).toString()) {
                case "minecraft:overworld" -> {
                    MinecraftServer minecraftServer = world.getServer();
                    yield minecraftServer == null ? "world" : minecraftServer.getSaveProperties().getLevelName();
                }
                case "minecraft:the_nether" -> "DIM-1";
                case "minecraft:the_end" -> "DIM1";
                default -> MinecraftServerHelper.getWorldId(world).getPath();
            };
            int areaY = world.getSeaLevel();
            MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
            MarkerSet tempMarkerSetAreas = markerAPI.getMarkerSet(areasId);
            MarkerSet markerSetAreas = tempMarkerSetAreas == null ? markerAPI.createMarkerSet(areasId, areasTitle, ObjectSet.of(markerAPI.getMarkerIcon(iconKey)), false) : tempMarkerSetAreas;
            markerSetAreas.getMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            MarkerSet tempMarkerSetAreaAreas = markerAPI.getMarkerSet(areaAreasId);
            MarkerSet markerSetAreaAreas = tempMarkerSetAreaAreas == null ? markerAPI.createMarkerSet(areaAreasId, areaAreasTitle, new ObjectArraySet(), false) : tempMarkerSetAreaAreas;
            markerSetAreaAreas.setHideByDefault(true);
            markerSetAreaAreas.getAreaMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
                markerSetAreas.createMarker(worldId + id, name, worldId, (double)areaX, (double)areaY, (double)areaZ, markerAPI.getMarkerIcon(iconKey), false);
                AreaMarker areaMarker = markerSetAreaAreas.createAreaMarker(worldId + id, name, false, worldId, new double[]{areaCorner1X, areaCorner2X}, new double[]{areaCorner1Z, areaCorner2Z}, false);
                areaMarker.setFillStyle(0.5, color.getRGB() & 0xFFFFFF);
                areaMarker.setLineStyle(1, 1.0, color.darker().getRGB() & 0xFFFFFF);
            });
        }
    }

    static {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                    UpdateDynmap.dynmapCommonAPI = dynmapCommonAPI;
                    try {
                        MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                        IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo.png", inputStream2 -> markerAPI.createMarkerIcon("mtr_station", "mtr_station", inputStream2));
                        IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo_grayscale.png", inputStream2 -> markerAPI.createMarkerIcon("mtr_depot", "mtr_depot", inputStream2));
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }
}

