/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.io.IOException;
import javax.imageio.ImageIO;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.SavedRailBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.IUpdateWebMap;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class UpdateSquaremap
implements IGui,
IUpdateWebMap {
    public static void updateSquaremap(World world) {
        try {
            UpdateSquaremap.updateSquaremap(world, MinecraftClientData.getInstance().stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "mtr_station");
            UpdateSquaremap.updateSquaremap(world, MinecraftClientData.getInstance().depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "mtr_depot");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    private static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> void updateSquaremap(World world, ObjectArraySet<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        SimpleLayerProvider providerAreaAreas;
        SimpleLayerProvider providerAreas;
        MapWorld mapWorld = SquaremapProvider.get().getWorldIfEnabled(WorldIdentifier.parse((String)MinecraftServerHelper.getWorldId(world).toString())).orElse(null);
        if (mapWorld == null) {
            return;
        }
        Registry layerRegistry = mapWorld.layerRegistry();
        if (layerRegistry.hasEntry(Key.of((String)areasId))) {
            providerAreas = (SimpleLayerProvider)layerRegistry.get(Key.of((String)areasId));
            providerAreas.clearMarkers();
        } else {
            providerAreas = SimpleLayerProvider.builder((String)areasTitle).showControls(true).build();
            layerRegistry.register(Key.of((String)areasId), (Object)providerAreas);
        }
        if (layerRegistry.hasEntry(Key.of((String)areaAreasId))) {
            providerAreaAreas = (SimpleLayerProvider)layerRegistry.get(Key.of((String)areaAreasId));
            providerAreaAreas.clearMarkers();
        } else {
            providerAreaAreas = SimpleLayerProvider.builder((String)areaAreasTitle).showControls(true).defaultHidden(true).build();
            layerRegistry.register(Key.of((String)areaAreasId), (Object)providerAreaAreas);
        }
        IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
            MarkerOptions markerOptions = MarkerOptions.builder().hoverTooltip(name).fillColor(color).strokeColor(color.darker()).build();
            providerAreas.addMarker(Key.of((String)id), Marker.icon((Point)Point.of((double)areaX, (double)areaZ), (Key)Key.of((String)iconKey), (int)24).markerOptions(markerOptions));
            providerAreaAreas.addMarker(Key.of((String)id), Marker.rectangle((Point)Point.of((double)areaCorner1X, (double)areaCorner1Z), (Point)Point.of((double)areaCorner2X, (double)areaCorner2Z)).markerOptions(markerOptions));
        });
    }

    static {
        try {
            Registry iconRegistry = SquaremapProvider.get().iconRegistry();
            IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo.png", inputStream2 -> {
                try {
                    iconRegistry.register(Key.of((String)"mtr_station"), (Object)ImageIO.read(inputStream2));
                }
                catch (IOException e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            });
            IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo_grayscale.png", inputStream2 -> {
                try {
                    iconRegistry.register(Key.of((String)"mtr_depot"), (Object)ImageIO.read(inputStream2));
                }
                catch (IOException e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }
}

