/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import com.mojang.blaze3d.systems.RenderSystem;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.data.IGui;

public class RenderDrivingOverlay
implements IGui {
    private static int accelerationSign;
    private static float doorValue;
    private static float speed;
    private static String thisStation;
    private static String nextStation;
    private static String thisRoute;
    private static String lastStation;
    private static int coolDown;
    private static final int HOT_BAR_WIDTH = 182;
    private static final int HOT_BAR_HEIGHT = 22;

    public static void render(GraphicsHolder graphicsHolder) {
        if (coolDown > 0) {
            --coolDown;
        } else {
            return;
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        Window window = minecraftClient.getWindow();
        if (clientPlayerEntity == null) {
            return;
        }
        graphicsHolder.push();
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingTexture(new Identifier("textures/gui/widgets.png"));
        int startX = (window.getScaledWidth() - 182) / 2;
        int startY = window.getScaledHeight() - (clientPlayerEntity.isCreative() ? 47 : 63);
        IGui.drawTexture(guiDrawing, startX, startY, 0.0f, 0.0f, 61, 22, 256, 256);
        IGui.drawTexture(guiDrawing, startX + 61, startY, 141.0f, 0.0f, 41, 22, 256, 256);
        IGui.drawTexture(guiDrawing, startX + 120, startY, 0.0f, 0.0f, 21, 22, 256, 256);
        IGui.drawTexture(guiDrawing, startX + 141, startY, 141.0f, 0.0f, 41, 22, 256, 256);
        IGui.drawTexture(guiDrawing, startX + 39 + Math.max(accelerationSign, -2) * 20, startY - 1, 0.0f, 22.0f, 24, 24, 256, 256);
        IGui.drawTexture(guiDrawing, startX + (doorValue > 0.0f ? (doorValue < 1.0f ? 139 : 159) : 119), startY - 1, 0.0f, 22.0f, 24, 24, 256, 256);
        guiDrawing.finishDrawingTexture();
        graphicsHolder.drawCenteredText("B2", (int)((float)startX + 5.5f), (int)((float)startY + 7.5f), doorValue == 0.0f && accelerationSign == -2 ? -1 : -10066330);
        graphicsHolder.drawCenteredText("B1", (int)((float)startX + 25.5f), (int)((float)startY + 7.5f), doorValue == 0.0f && accelerationSign == -1 ? -1 : -10066330);
        graphicsHolder.drawCenteredText("N", (int)((float)startX + 48.5f), (int)((float)startY + 7.5f), doorValue == 0.0f && accelerationSign == 0 ? -1 : -10066330);
        graphicsHolder.drawCenteredText("P1", (int)((float)startX + 65.5f), (int)((float)startY + 7.5f), doorValue == 0.0f && accelerationSign == 1 ? -1 : -10066330);
        graphicsHolder.drawCenteredText("P2", (int)((float)startX + 85.5f), (int)((float)startY + 7.5f), doorValue == 0.0f && accelerationSign == 2 ? -1 : -10066330);
        graphicsHolder.drawCenteredText("DC", (int)((float)startX + 125.5f), (int)((float)startY + 7.5f), speed == 0.0f && doorValue == 0.0f ? -1 : -10066330);
        graphicsHolder.drawCenteredText(String.valueOf((float)Math.round(doorValue * 10.0f) / 10.0f), (int)((float)startX + 144.5f), (int)((float)startY + 7.5f), doorValue > 0.0f && doorValue < 1.0f ? -1 : -10066330);
        graphicsHolder.drawCenteredText("DO", (int)((float)startX + 165.5f), (int)((float)startY + 7.5f), speed == 0.0f && doorValue == 1.0f ? -1 : -10066330);
        String speedText = Utilities.round(speed * 3.6f, 1) + " km/h";
        graphicsHolder.drawText(speedText, startX - GraphicsHolder.getTextWidth(speedText) - 6, (int)((float)window.getScaledHeight() - 14.5f), -1, true, GraphicsHolder.getDefaultLight());
        if (thisStation != null) {
            graphicsHolder.drawText(thisStation, startX + 182 + 6, (int)((float)window.getScaledHeight() - 44.5f), -1, true, GraphicsHolder.getDefaultLight());
        }
        if (nextStation != null) {
            graphicsHolder.drawText("> " + nextStation, startX + 182 + 6, (int)((float)window.getScaledHeight() - 34.5f), -1, true, GraphicsHolder.getDefaultLight());
        }
        if (thisRoute != null) {
            graphicsHolder.drawText(thisRoute, startX + 182 + 6, (int)((float)window.getScaledHeight() - 19.5f), -1, true, GraphicsHolder.getDefaultLight());
        }
        if (lastStation != null) {
            graphicsHolder.drawText("> " + lastStation, startX + 182 + 6, (int)((float)window.getScaledHeight() - 9.5f), -1, true, GraphicsHolder.getDefaultLight());
        }
        RenderSystem.m_69461_();
        graphicsHolder.pop();
    }
}

