/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.Collections;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.block.BlockSignalBase;
import org.mtr.mod.block.BlockSignalLightBase;
import org.mtr.mod.block.BlockSignalSemaphoreBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.StoredMatrixTransformations;

public abstract class RenderSignalBase<T extends BlockSignalBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IBlock,
IGui {
    protected final int aspects;
    private final float colorIndicatorHeight;

    public RenderSignalBase(BlockEntityRenderer.Argument dispatcher, int colorIndicatorHeight, int aspects) {
        super(dispatcher);
        this.aspects = aspects;
        this.colorIndicatorHeight = (float)colorIndicatorHeight / 16.0f + 0.003125f;
    }

    @Override
    public final void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockSignalLightBase) && !(state.getBlock().data instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        float angle = BlockSignalBase.getAngle(state);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getX(), ((BlockEntityAbstractMapping)((Object)entity)).getPos2().getY(), 0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getZ());
        for (int i = 0; i < (((BlockSignalBase.BlockEntityBase)((Object)entity)).isDoubleSided ? 2 : 1); ++i) {
            float newAngle = angle + (float)(i * 180);
            boolean isBackSide = i == 1;
            ObjectObjectImmutablePair<IntArrayList, IntAVLTreeSet> aspects = RenderSignalBase.getAspects(pos, newAngle + 90.0f);
            IntArrayList detectedColors = aspects.left();
            if (detectedColors.isEmpty()) continue;
            StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
            storedMatrixTransformationsNew.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(-newAngle));
            IntAVLTreeSet filterColors = ((BlockSignalBase.BlockEntityBase)((Object)entity)).getSignalColors(isBackSide);
            if (RenderRails.isHoldingRailRelated(clientPlayerEntity)) {
                float xStart = -0.015625f * (float)detectedColors.size();
                for (int j = 0; j < detectedColors.size(); ++j) {
                    int signalColor = detectedColors.getInt(j);
                    boolean occupied = aspects.right().contains(signalColor);
                    float x = xStart + (float)j * 0.03125f;
                    float width = 0.03125f / (float)(filterColors.isEmpty() || filterColors.contains(signalColor) ? 1 : 8);
                    int lightNew = occupied ? MainRenderer.getFlashingLight() : GraphicsHolder.getDefaultLight();
                    MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, occupied ? QueuedRenderLayer.EXTERIOR : QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                        storedMatrixTransformationsNew.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                        IDrawing.drawTexture(graphicsHolderNew, x, this.colorIndicatorHeight, -0.15625f, x + 0.03125f, this.colorIndicatorHeight, -0.15625f, x + 0.03125f, this.colorIndicatorHeight, -0.15625f - width, x, this.colorIndicatorHeight, -0.15625f - width, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, signalColor | 0xFF000000, lightNew);
                        graphicsHolderNew.pop();
                    });
                }
            }
            this.render(storedMatrixTransformationsNew, entity, tickDelta, aspects.right().intStream().anyMatch(color -> filterColors.isEmpty() || filterColors.contains(color)) ? 1 : 0, isBackSide);
        }
    }

    protected abstract void render(StoredMatrixTransformations var1, T var2, float var3, int var4, boolean var5);

    public static ObjectObjectImmutablePair<IntArrayList, IntAVLTreeSet> getAspects(BlockPos blockPos, float angle) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return new ObjectObjectImmutablePair<IntArrayList, IntAVLTreeSet>(new IntArrayList(), new IntAVLTreeSet());
        }
        BlockPos startPos = RenderSignalBase.getNodePos(clientWorld, blockPos, Direction.fromRotation(angle));
        if (startPos == null) {
            return new ObjectObjectImmutablePair<IntArrayList, IntAVLTreeSet>(new IntArrayList(), new IntAVLTreeSet());
        }
        MinecraftClientData minecraftClientData = MinecraftClientData.getInstance();
        IntArrayList detectedColors = new IntArrayList();
        IntAVLTreeSet occupiedColors = new IntAVLTreeSet();
        minecraftClientData.positionsToRail.getOrDefault(Init.blockPosToPosition(startPos), new Object2ObjectOpenHashMap()).forEach((endPosition, rail) -> {
            if (Math.abs(Utilities.circularDifference(Math.round(Math.toDegrees(Math.atan2(endPosition.getZ() - (long)startPos.getZ(), endPosition.getX() - (long)startPos.getX()))), Math.round(angle), 360L)) < 90L) {
                rail.getSignalColors().forEach(detectedColors::add);
                minecraftClientData.railIdToBlockedSignalColors.getOrDefault(rail.getHexId(), new LongArrayList()).forEach(color -> occupiedColors.add((int)color));
            }
        });
        Collections.sort(detectedColors);
        return new ObjectObjectImmutablePair<IntArrayList, IntAVLTreeSet>(detectedColors, occupiedColors);
    }

    private static BlockPos getNodePos(ClientWorld world, BlockPos pos, Direction facing) {
        int[] checkDistance;
        for (int z : checkDistance = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4}) {
            for (int x : checkDistance) {
                for (int y = -5; y <= 0; ++y) {
                    BlockPos checkPos = pos.up(y).offset(facing.rotateYClockwise(), x).offset(facing, z);
                    BlockState checkState = world.getBlockState(checkPos);
                    if (!(checkState.getBlock().data instanceof BlockNode)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

