/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPlatform;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderVehicleTransformationHelper;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderVehicleHelper {
    public static final float HALF_PLAYER_WIDTH = 0.3f;
    private static final int CHECK_DOOR_RADIUS_XZ = 1;
    private static final int CHECK_DOOR_RADIUS_Y = 2;
    private static final double RIDE_STEP_THRESHOLD = 0.75;

    public static boolean canOpenDoors(Box doorway, RenderVehicleTransformationHelper renderVehicleTransformationHelper, double doorValue) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return false;
        }
        Vector3d doorwayPosition1 = renderVehicleTransformationHelper.transformForwards(new Vector3d(doorway.getMinXMapped(), doorway.getMaxYMapped(), doorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition2 = renderVehicleTransformationHelper.transformForwards(new Vector3d(doorway.getMaxXMapped(), doorway.getMaxYMapped(), doorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition3 = renderVehicleTransformationHelper.transformForwards(new Vector3d(doorway.getMaxXMapped(), doorway.getMaxYMapped(), doorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition4 = renderVehicleTransformationHelper.transformForwards(new Vector3d(doorway.getMinXMapped(), doorway.getMaxYMapped(), doorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        double minX = Math.min(Math.min(doorwayPosition1.getXMapped(), doorwayPosition2.getXMapped()), Math.min(doorwayPosition3.getXMapped(), doorwayPosition4.getXMapped()));
        double maxX = Math.max(Math.max(doorwayPosition1.getXMapped(), doorwayPosition2.getXMapped()), Math.max(doorwayPosition3.getXMapped(), doorwayPosition4.getXMapped()));
        double minY = Math.min(Math.min(doorwayPosition1.getYMapped(), doorwayPosition2.getYMapped()), Math.min(doorwayPosition3.getYMapped(), doorwayPosition4.getYMapped()));
        double maxY = Math.max(Math.max(doorwayPosition1.getYMapped(), doorwayPosition2.getYMapped()), Math.max(doorwayPosition3.getYMapped(), doorwayPosition4.getYMapped()));
        double minZ = Math.min(Math.min(doorwayPosition1.getZMapped(), doorwayPosition2.getZMapped()), Math.min(doorwayPosition3.getZMapped(), doorwayPosition4.getZMapped()));
        double maxZ = Math.max(Math.max(doorwayPosition1.getZMapped(), doorwayPosition2.getZMapped()), Math.max(doorwayPosition3.getZMapped(), doorwayPosition4.getZMapped()));
        boolean canOpenDoors = false;
        for (double checkX = minX - 1.0; checkX <= maxX + 1.0; checkX += 1.0) {
            for (double checkY = minY - 2.0; checkY <= maxY + 2.0; checkY += 1.0) {
                for (double checkZ = minZ - 1.0; checkZ <= maxZ + 1.0; checkZ += 1.0) {
                    BlockPos checkPos = Init.newBlockPos(checkX, checkY, checkZ);
                    BlockState blockState = clientWorld.getBlockState(checkPos);
                    Block block = blockState.getBlock();
                    if (block.data instanceof BlockPlatform) {
                        canOpenDoors = true;
                        continue;
                    }
                    if (!(block.data instanceof BlockPSDAPGDoorBase) || !((Boolean)blockState.get(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.UNLOCKED.data))).booleanValue()) continue;
                    canOpenDoors = true;
                    BlockEntity blockEntity = clientWorld.getBlockEntity(checkPos);
                    if (blockEntity == null || !(blockEntity.data instanceof BlockPSDAPGDoorBase.BlockEntityBase)) continue;
                    ((BlockPSDAPGDoorBase.BlockEntityBase)blockEntity.data).open(doorValue);
                }
            }
        }
        return canOpenDoors;
    }

    public static void renderModel(RenderVehicleTransformationHelper renderVehicleTransformationHelper, double oscillationAmount, Consumer<StoredMatrixTransformations> render) {
        StoredMatrixTransformations storedMatrixTransformations = renderVehicleTransformationHelper.getStoredMatrixTransformations();
        storedMatrixTransformations.add(graphicsHolder -> {
            renderVehicleTransformationHelper.transformBackwards(new Object(), (object, pitch) -> {
                graphicsHolder.rotateXRadians((float)(Math.PI - (double)pitch));
                return new Object();
            }, (object, yaw) -> {
                graphicsHolder.rotateYRadians((float)(Math.PI - (double)yaw));
                return new Object();
            }, (object, x, y, z) -> {
                if (!storedMatrixTransformations.useDefaultOffset) {
                    graphicsHolder.translate(-x, -y, -z);
                }
                return new Object();
            });
            graphicsHolder.rotateZDegrees((float)oscillationAmount);
        });
        render.accept(storedMatrixTransformations);
    }

    public static void renderFloorOrDoorway(Box floorOrDoorway, int color, Vector3d playerPosition, RenderVehicleTransformationHelper renderVehicleTransformationHelper) {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null && clientPlayerEntity.isHolding(Items.BRUSH.get())) {
            Vector3d corner1 = renderVehicleTransformationHelper.transformForwards(new Vector3d(floorOrDoorway.getMinXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner2 = renderVehicleTransformationHelper.transformForwards(new Vector3d(floorOrDoorway.getMaxXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner3 = renderVehicleTransformationHelper.transformForwards(new Vector3d(floorOrDoorway.getMaxXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner4 = renderVehicleTransformationHelper.transformForwards(new Vector3d(floorOrDoorway.getMinXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            int newColor = RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() - (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() - (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() + (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() - (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() + (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() + (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() - (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() + (double)0.3f) ? -16711936 : color;
            MainRenderer.scheduleRender(QueuedRenderLayer.LINES, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> {
                RenderVehicleHelper.drawLine(graphicsHolder, corner1, corner2, newOffset, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner2, corner3, newOffset, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner3, corner4, newOffset, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner4, corner1, newOffset, newColor);
            }));
        }
    }

    public static <T extends NameColorDataBase> ObjectArrayList<VehicleProperties> getTransformedVehiclePropertiesList(T vehicle, ObjectArrayList<VehicleProperties> vehiclePropertiesList, Vector3d cameraShakeOffset) {
        VehicleProperties ridingVehicleProperties;
        IntObjectImmutablePair<ObjectObjectImmutablePair<Vector3d, Double>> ridingVehicleCarNumberAndOffset = VehicleRidingMovement.getRidingVehicleCarNumberAndOffset(vehicle.getId());
        if (ridingVehicleCarNumberAndOffset != null && (ridingVehicleProperties = vehiclePropertiesList.get(ridingVehicleCarNumberAndOffset.leftInt())) != null) {
            Vector3d playerRelativePosition = ridingVehicleCarNumberAndOffset.right().left();
            Vector3d playerRelativePositionNew = playerRelativePosition == null ? Vector3d.getZeroMapped() : playerRelativePosition;
            double playerYOffset = playerRelativePositionNew.rotateX((float)ridingVehicleProperties.renderVehicleTransformationHelperAbsolute.pitch).getYMapped() - playerRelativePositionNew.getYMapped();
            Vector cameraShake = new Vector(cameraShakeOffset.getXMapped(), cameraShakeOffset.getYMapped(), cameraShakeOffset.getZMapped());
            return vehiclePropertiesList.stream().map(vehicleProperties -> {
                ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsList = new ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>();
                ObjectArrayList<Vector> averageAbsoluteBogiePositionsList = new ObjectArrayList<Vector>();
                vehicleProperties.bogiePositionsListNormalized.forEach((Consumer<ObjectObjectImmutablePair<Vector, Vector>>)((Consumer<ObjectObjectImmutablePair>)bogiePositions -> {
                    bogiePositionsList.add(new ObjectObjectImmutablePair<Vector, Vector>(ridingVehicleProperties.renderVehicleTransformationHelperAbsolute.transformBackwards(((Vector)bogiePositions.left()).add(cameraShake), (vector, pitch) -> vector, Vector::rotateY, Vector::add).add(-playerRelativePositionNew.getXMapped(), -playerRelativePositionNew.getYMapped() - playerYOffset, -playerRelativePositionNew.getZMapped()), ridingVehicleProperties.renderVehicleTransformationHelperAbsolute.transformBackwards(((Vector)bogiePositions.right()).add(cameraShake), (vector, pitch) -> vector, Vector::rotateY, Vector::add).add(-playerRelativePositionNew.getXMapped(), -playerRelativePositionNew.getYMapped() - playerYOffset, -playerRelativePositionNew.getZMapped())));
                    averageAbsoluteBogiePositionsList.add(Vector.getAverage((Vector)bogiePositions.left(), (Vector)bogiePositions.right()).add(cameraShake));
                }));
                return new VehicleProperties(vehicleProperties.vehicleCar, bogiePositionsList, averageAbsoluteBogiePositionsList, vehicleProperties.renderVehicleTransformationHelperAbsolute, ridingVehicleProperties.renderVehicleTransformationHelperAbsolute, (Double)((ObjectObjectImmutablePair)ridingVehicleCarNumberAndOffset.right()).right());
            }).collect(Collectors.toCollection(ObjectArrayList::new));
        }
        return vehiclePropertiesList;
    }

    public static boolean boxContains(Box box, double x, double y, double z) {
        return Utilities.isBetween(x, box.getMinXMapped(), box.getMaxXMapped()) && Utilities.isBetween(y, box.getMinYMapped(), box.getMaxYMapped(), 0.75) && Utilities.isBetween(z, box.getMinZMapped(), box.getMaxZMapped());
    }

    private static void drawLine(GraphicsHolder graphicsHolder, Vector3d corner1, Vector3d corner2, Vector3d offset, int color) {
        graphicsHolder.drawLineInWorld((float)(corner1.getXMapped() - offset.getXMapped()), (float)(corner1.getYMapped() - offset.getYMapped()), (float)(corner1.getZMapped() - offset.getZMapped()), (float)(corner2.getXMapped() - offset.getXMapped()), (float)(corner2.getYMapped() - offset.getYMapped()), (float)(corner2.getZMapped() - offset.getZMapped()), color);
    }

    public static class VehicleProperties {
        public final VehicleCar vehicleCar;
        public final ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsList;
        public final ObjectArrayList<Vector> averageAbsoluteBogiePositionsList;
        public final RenderVehicleTransformationHelper renderVehicleTransformationHelperAbsolute;
        public final RenderVehicleTransformationHelper renderVehicleTransformationHelperOffset;
        private final ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsListNormalized;

        public VehicleProperties(ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>> vehicleCarAndPosition, boolean ignorePitch) {
            this.vehicleCar = vehicleCarAndPosition.left();
            this.bogiePositionsList = vehicleCarAndPosition.right();
            if (ignorePitch) {
                double y = 0.0;
                int count = 0;
                for (ObjectObjectImmutablePair objectObjectImmutablePair : this.bogiePositionsList) {
                    y += ((Vector)objectObjectImmutablePair.left()).y + ((Vector)objectObjectImmutablePair.right()).y;
                    count += 2;
                }
                double yAverage = y / (double)count;
                this.bogiePositionsListNormalized = new ObjectArrayList();
                this.bogiePositionsList.forEach((Consumer<ObjectObjectImmutablePair<Vector, Vector>>)((Consumer<ObjectObjectImmutablePair>)tempBogiePositions -> this.bogiePositionsListNormalized.add(new ObjectObjectImmutablePair<Vector, Vector>(new Vector(((Vector)tempBogiePositions.left()).x, yAverage, ((Vector)tempBogiePositions.left()).z), new Vector(((Vector)tempBogiePositions.right()).x, yAverage, ((Vector)tempBogiePositions.right()).z)))));
            } else {
                this.bogiePositionsListNormalized = this.bogiePositionsList;
            }
            this.averageAbsoluteBogiePositionsList = new ObjectArrayList();
            this.bogiePositionsList.forEach((Consumer<ObjectObjectImmutablePair<Vector, Vector>>)((Consumer<ObjectObjectImmutablePair>)bogiePositions -> this.averageAbsoluteBogiePositionsList.add(Vector.getAverage((Vector)bogiePositions.left(), (Vector)bogiePositions.right()))));
            this.renderVehicleTransformationHelperAbsolute = this.renderVehicleTransformationHelperOffset = new RenderVehicleTransformationHelper(this.bogiePositionsListNormalized, this.vehicleCar.getBogie1Position(), this.vehicleCar.getBogie2Position(), this.vehicleCar.getLength(), false, false, 0.0, 0.0);
        }

        private VehicleProperties(VehicleCar vehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsList, ObjectArrayList<Vector> averageAbsoluteBogiePositionsList, RenderVehicleTransformationHelper renderVehicleTransformationHelperAbsolute, RenderVehicleTransformationHelper ridingRenderVehicleTransformationHelperAbsolute, @Nullable Double ridingYawDifference) {
            this.vehicleCar = vehicleCar;
            this.bogiePositionsList = bogiePositionsList;
            this.bogiePositionsListNormalized = this.bogiePositionsList;
            this.averageAbsoluteBogiePositionsList = averageAbsoluteBogiePositionsList;
            this.renderVehicleTransformationHelperAbsolute = renderVehicleTransformationHelperAbsolute;
            this.renderVehicleTransformationHelperOffset = new RenderVehicleTransformationHelper(bogiePositionsList, vehicleCar.getBogie1Position(), vehicleCar.getBogie2Position(), vehicleCar.getLength(), true, ridingYawDifference != null, ridingYawDifference == null ? ridingRenderVehicleTransformationHelperAbsolute.yaw : ridingYawDifference, -ridingRenderVehicleTransformationHelperAbsolute.pitch);
        }
    }
}

