/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.Consumer;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Camera;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderVehicleTransformationHelper {
    public final int light;
    public final Vector pivotPosition;
    public final double yaw;
    public final double pitch;
    private final boolean renderWithRespectToPlayerPosition;
    private final boolean renderWithRespectToPlayerRotation;
    private final double ridingYawDifference;
    private final double ridingPitchDifference;

    public RenderVehicleTransformationHelper(ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsList, double bogie1Position, double bogie2Position, double length, boolean renderWithRespectToPlayerPosition, boolean renderWithRespectToPlayerRotation, double ridingYawDifference, double ridingPitchDifference) {
        if (bogiePositionsList.size() == 1 || bogiePositionsList.size() == 2) {
            Vector bogiesMidpoint;
            if (bogiePositionsList.size() == 1) {
                ObjectObjectImmutablePair<Vector, Vector> bogiePositions = bogiePositionsList.get(0);
                bogiesMidpoint = Vector.getAverage(bogiePositions.left(), bogiePositions.right());
                this.yaw = RenderVehicleTransformationHelper.getYaw(bogiePositions.left(), bogiePositions.right());
                this.pitch = RenderVehicleTransformationHelper.getPitch(bogiePositions.left(), bogiePositions.right());
            } else {
                Vector average1 = Vector.getAverage(bogiePositionsList.get(0).left(), bogiePositionsList.get(0).right());
                Vector average2 = Vector.getAverage(bogiePositionsList.get(1).left(), bogiePositionsList.get(1).right());
                bogiesMidpoint = Vector.getAverage(average1, average2);
                this.yaw = RenderVehicleTransformationHelper.getYaw(average1, average2);
                this.pitch = RenderVehicleTransformationHelper.getPitch(average1, average2);
            }
            double pivotOffset = Utilities.getAverage(bogie1Position, bogie2Position);
            double halfLength = length / 2.0;
            double pivotOffset1 = -pivotOffset - halfLength;
            double pivotOffset2 = -pivotOffset + halfLength;
            Vector rotationalVector = new Vector(0.0, 0.0, 1.0).rotateX(this.pitch).rotateY(this.yaw);
            this.pivotPosition = Vector.getAverage(rotationalVector.multiply(pivotOffset1, pivotOffset1, pivotOffset1).add(bogiesMidpoint), rotationalVector.multiply(pivotOffset2, pivotOffset2, pivotOffset2).add(bogiesMidpoint));
        } else {
            this.pivotPosition = new Vector(0.0, 0.0, 0.0);
            this.yaw = 0.0;
            this.pitch = 0.0;
        }
        this.light = RenderVehicleTransformationHelper.getLight(this.pivotPosition);
        this.renderWithRespectToPlayerPosition = renderWithRespectToPlayerPosition;
        this.renderWithRespectToPlayerRotation = renderWithRespectToPlayerRotation;
        this.ridingYawDifference = ridingYawDifference;
        this.ridingPitchDifference = ridingPitchDifference;
    }

    public RenderVehicleTransformationHelper(ObjectObjectImmutablePair<Vector, Vector> bogiePositions, Vector averageAbsoluteBogiePosition, RenderVehicleTransformationHelper renderVehicleTransformationHelper) {
        this.pivotPosition = averageAbsoluteBogiePosition;
        this.yaw = RenderVehicleTransformationHelper.getYaw(bogiePositions.left(), bogiePositions.right());
        this.pitch = RenderVehicleTransformationHelper.getPitch(bogiePositions.left(), bogiePositions.right());
        this.light = RenderVehicleTransformationHelper.getLight(this.pivotPosition);
        this.renderWithRespectToPlayerPosition = renderVehicleTransformationHelper.renderWithRespectToPlayerPosition;
        this.renderWithRespectToPlayerRotation = renderVehicleTransformationHelper.renderWithRespectToPlayerRotation;
        this.ridingYawDifference = renderVehicleTransformationHelper.ridingYawDifference;
        this.ridingPitchDifference = renderVehicleTransformationHelper.ridingPitchDifference;
    }

    public <T> T transformForwards(T initialValue, Rotate<T> rotateX, Rotate<T> rotateY, Translate<T> translate) {
        return translate.apply(rotateY.apply(rotateX.apply(initialValue, (float)this.pitch), (float)this.yaw), this.pivotPosition.x, this.pivotPosition.y, this.pivotPosition.z);
    }

    public <T> T transformBackwards(T initialValue, Rotate<T> rotateX, Rotate<T> rotateY, Translate<T> translate) {
        return rotateX.apply(rotateY.apply(translate.apply(initialValue, -this.pivotPosition.x, -this.pivotPosition.y, -this.pivotPosition.z), (float)(-this.yaw)), (float)(-this.pitch));
    }

    public StoredMatrixTransformations getStoredMatrixTransformations() {
        StoredMatrixTransformations storedMatrixTransformations = this.renderWithRespectToPlayerPosition ? new StoredMatrixTransformations() : new StoredMatrixTransformations(this.pivotPosition.x, this.pivotPosition.y, this.pivotPosition.z);
        storedMatrixTransformations.add(this::transformGraphicsHolder);
        return storedMatrixTransformations;
    }

    public void render(GraphicsHolder graphicsHolder, Vector3d offset, Consumer<Vector3d> newConsumer) {
        graphicsHolder.push();
        this.transformGraphicsHolder(graphicsHolder);
        newConsumer.accept(this.renderWithRespectToPlayerPosition ? Vector3d.getZeroMapped() : offset);
        graphicsHolder.pop();
    }

    private void transformGraphicsHolder(GraphicsHolder graphicsHolder) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        Camera camera = minecraftClient.getGameRendererMapped().getCamera();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        if (this.renderWithRespectToPlayerRotation) {
            graphicsHolder.rotateYDegrees(-camera.getYaw());
            if (camera.isThirdPerson()) {
                Entity entity = new Entity((net.minecraft.world.entity.Entity)clientPlayerEntity.data);
                if (Math.abs(EntityHelper.getYaw(entity) - camera.getYaw()) > 90.0f) {
                    graphicsHolder.rotateYDegrees(180.0f);
                }
            }
        }
        graphicsHolder.rotateYRadians((float)this.ridingYawDifference);
    }

    private static int getLight(Vector pivotPosition) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return 0;
        }
        BlockPos blockPos = Init.newBlockPos(pivotPosition.x, pivotPosition.y + 1.0, pivotPosition.z);
        return LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
    }

    private static double getYaw(Vector position1, Vector position2) {
        double x1 = position1.x;
        double z1 = position1.z;
        double x2 = position2.x;
        double z2 = position2.z;
        return Math.atan2(x2 - x1, z2 - z1);
    }

    private static double getPitch(Vector position1, Vector position2) {
        double x1 = position1.x;
        double y1 = position1.y;
        double z1 = position1.z;
        double x2 = position2.x;
        double y2 = position2.y;
        double z2 = position2.z;
        return Math.atan2(y2 - y1, Math.sqrt((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1)));
    }

    @FunctionalInterface
    public static interface Rotate<T> {
        public T apply(T var1, float var2);
    }

    @FunctionalInterface
    public static interface Translate<T> {
        public T apply(T var1, double var2, double var4, double var6);
    }
}

