/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.Consumer;
import net.minecraft.world.level.BlockGetter;
import org.mtr.libraries.com.logisticscraft.occlusionculling.DataProvider;
import org.mtr.libraries.com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mod.CustomThread;
import org.mtr.mod.Init;

public final class WorkerThread
extends CustomThread {
    private int renderDistance;
    private OcclusionCullingInstance occlusionCullingInstance;
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueue1 = new ObjectArrayList();
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueue2 = new ObjectArrayList();
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueue3 = new ObjectArrayList();
    private final ObjectArrayList<Runnable> queue = new ObjectArrayList();

    @Override
    protected void runTick() {
        if (!(this.occlusionQueue1.isEmpty() && this.occlusionQueue2.isEmpty() && this.occlusionQueue3.isEmpty())) {
            this.updateInstance();
            this.occlusionCullingInstance.resetCache();
            WorkerThread.run(this.occlusionQueue1, task -> task.accept(this.occlusionCullingInstance));
            WorkerThread.run(this.occlusionQueue2, task -> task.accept(this.occlusionCullingInstance));
            WorkerThread.run(this.occlusionQueue3, task -> task.accept(this.occlusionCullingInstance));
        }
        WorkerThread.run(this.queue, Runnable::run);
    }

    @Override
    protected boolean isRunning() {
        return MinecraftClient.getInstance().isRunning();
    }

    public void scheduleVehicles(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueue1.size() < 2) {
            this.occlusionQueue1.add(consumer);
        }
    }

    public void scheduleLifts(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueue2.size() < 2) {
            this.occlusionQueue2.add(consumer);
        }
    }

    public void scheduleRails(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueue3.size() < 2) {
            this.occlusionQueue3.add(consumer);
        }
    }

    public void scheduleDynamicTextures(Runnable runnable2) {
        this.queue.add(runnable2);
    }

    private void updateInstance() {
        int newRenderDistance = MinecraftClientHelper.getRenderDistance();
        if (this.renderDistance != newRenderDistance) {
            this.renderDistance = newRenderDistance;
            this.occlusionCullingInstance = new OcclusionCullingInstance(this.renderDistance * 16, new CullingDataProvider());
        }
    }

    private static <T> void run(ObjectArrayList<T> queue, Consumer<T> consumer) {
        if (!queue.isEmpty()) {
            try {
                T task = queue.remove(0);
                if (task != null) {
                    consumer.accept(task);
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
    }

    private static final class CullingDataProvider
    implements DataProvider {
        private final MinecraftClient minecraftClient = MinecraftClient.getInstance();
        private ClientWorld clientWorld = null;

        private CullingDataProvider() {
        }

        @Override
        public boolean prepareChunk(int chunkX, int chunkZ) {
            this.clientWorld = this.minecraftClient.getWorldMapped();
            return this.clientWorld != null;
        }

        @Override
        public boolean isOpaqueFullCube(int x, int y, int z) {
            BlockPos blockPos = new BlockPos(x, y, z);
            return this.clientWorld != null && this.clientWorld.getBlockState(blockPos).isOpaqueFullCube(new BlockView((BlockGetter)this.clientWorld.data), blockPos);
        }

        @Override
        public void cleanup() {
            this.clientWorld = null;
        }
    }
}

