/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.mapping.holder.Identifier;

public interface CustomResourceTools
extends SerializedDataBase {
    @Nullable
    public static Identifier formatIdentifier(String identifierString, String extension) {
        String newIdentifierString = CustomResourceTools.formatIdentifierString(identifierString);
        if (newIdentifierString.isEmpty()) {
            return null;
        }
        if (newIdentifierString.endsWith("." + extension)) {
            return new Identifier(newIdentifierString);
        }
        return new Identifier(String.format("%s.%s", newIdentifierString, extension));
    }

    public static Identifier formatIdentifierWithDefault(String identifierString, String extension) {
        Identifier identifier = CustomResourceTools.formatIdentifier(identifierString, extension);
        return identifier == null ? new Identifier("mtr", "textures/block/transparent.png") : identifier;
    }

    public static String formatIdentifierString(String text) {
        return Arrays.stream(text.split(":")).map(textPart -> textPart.replaceAll("[^a-z0-9/._-]", "")).collect(Collectors.joining(":"));
    }

    public static int colorStringToInt(String color) {
        try {
            return Integer.parseInt(color.toUpperCase(Locale.ENGLISH).replaceAll("[^\\dA-F]", ""), 16);
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

