/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.core.data.Data;
import org.mtr.core.data.Vehicle;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.OverlayTexture;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.MutableBox;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.generated.resource.ModelPropertiesPartSchema;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.DisplayOption;
import org.mtr.mod.resource.DisplayType;
import org.mtr.mod.resource.DoorAnimationType;
import org.mtr.mod.resource.ModelDisplayPart;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.PartPosition;
import org.mtr.mod.resource.PartType;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.RenderStage;
import org.mtr.mod.resource.VehicleResource;

public final class ModelPropertiesPart
extends ModelPropertiesPartSchema
implements IGui {
    private final ObjectArrayList<PartDetails> partDetailsList = new ObjectArrayList();
    private final ObjectArrayList<DisplayPartDetails> displayPartDetailsList = new ObjectArrayList();
    private final int displayColorCjkInt;
    private final int displayColorInt;
    private static final int LINE_PADDING = 2;

    public ModelPropertiesPart(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
        this.displayColorInt = ModelPropertiesPart.parseColor(this.displayColor, 0xFF9900);
        this.displayColorCjkInt = ModelPropertiesPart.parseColor(this.displayColorCjk, this.displayColorInt);
    }

    ModelPropertiesPart(ObjectSet<String> names) {
        super(PartCondition.NORMAL, RenderStage.EXTERIOR, PartType.NORMAL, 0.0, 0.0, "", "", 0.0, 0.0, 0.0, DisplayType.DESTINATION, "", 0.0, 0.0, DoorAnimationType.STANDARD);
        this.names.addAll(names);
        this.positionDefinitions.add("");
        this.displayColorInt = 0;
        this.displayColorCjkInt = 0;
    }

    public void writeCache(Identifier texture, Object2ObjectOpenHashMap<String, ObjectObjectImmutablePair<ModelPartExtension, MutableBox>> nameToPart, Object2ObjectOpenHashMap<String, ModelDisplayPart> nameToDisplayPart, PositionDefinitions positionDefinitionsObject, ObjectArraySet<Box> floors, ObjectArraySet<Box> doorways, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStage, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStageDoorsClosed) {
        OptimizedModelWrapper optimizedModelDoor;
        ObjectArrayList<ModelPartExtension> modelParts = new ObjectArrayList<ModelPartExtension>();
        MutableBox mutableBox = new MutableBox();
        ObjectArrayList modelDisplayParts = new ObjectArrayList();
        this.names.forEach(name -> {
            ModelDisplayPart modelDisplayPart;
            ObjectObjectImmutablePair part = (ObjectObjectImmutablePair)nameToPart.get(name);
            if (part != null) {
                modelParts.add((ModelPartExtension)part.left());
                mutableBox.add((MutableBox)part.right());
            }
            if ((modelDisplayPart = (ModelDisplayPart)nameToDisplayPart.get(name)) != null) {
                modelDisplayParts.add(modelDisplayPart);
            }
        });
        if (this.isDoor()) {
            OptimizedModelWrapper.MaterialGroupWrapper materialGroup = new OptimizedModelWrapper.MaterialGroupWrapper(this.renderStage.shaderType, texture);
            modelParts.forEach(modelPart -> materialGroup.addCube((ModelPartExtension)modelPart, 0.0, 0.0, 0.0, false, 0xF000B0));
            optimizedModelDoor = OptimizedModelWrapper.fromMaterialGroups(ObjectArrayList.of(new OptimizedModelWrapper.MaterialGroupWrapper[]{materialGroup}));
        } else {
            optimizedModelDoor = null;
        }
        this.positionDefinitions.forEach(positionDefinitionName -> positionDefinitionsObject.getPositionDefinition((String)positionDefinitionName, (positions, positionsFlipped) -> {
            switch (this.type) {
                case NORMAL: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> {
                        if (!this.isDoor()) {
                            this.addCube(texture, modelParts, materialGroupsForPartConditionAndRenderStage, x, y, z, flipped);
                        }
                        this.addCube(texture, modelParts, materialGroupsForPartConditionAndRenderStageDoorsClosed, x, y, z, flipped);
                        this.partDetailsList.add(new PartDetails(modelParts, optimizedModelDoor, ModelPropertiesPart.addBox(mutableBox.get(), x, y, z, flipped), x, y, z, flipped));
                    });
                    break;
                }
                case DISPLAY: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> this.displayPartDetailsList.add(new DisplayPartDetails(modelDisplayParts, x, y, z, flipped)));
                    break;
                }
                case FLOOR: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> mutableBox.getAll().forEach(box -> floors.add(ModelPropertiesPart.addBox(box, x, y, z, flipped))));
                    break;
                }
                case DOORWAY: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> mutableBox.getAll().forEach(box -> doorways.add(ModelPropertiesPart.addBox(box, x, y, z, flipped))));
                }
            }
        }));
    }

    public void writeCache(Map<String, OptimizedModel.ObjModel> nameToObjModels, PositionDefinitions positionDefinitionsObject, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStage, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStageDoorsClosed, double modelYOffset) {
        ObjectArrayList objModels = new ObjectArrayList();
        MutableBox mutableBox = new MutableBox();
        this.names.forEach(name -> {
            OptimizedModel.ObjModel objModel = (OptimizedModel.ObjModel)nameToObjModels.get(name);
            if (objModel != null) {
                objModels.add(new OptimizedModelWrapper.ObjModelWrapper(objModel));
                mutableBox.add(new Box(-objModel.getMinX(), -objModel.getMinY(), -objModel.getMinZ(), -objModel.getMaxX(), -objModel.getMaxY(), -objModel.getMaxZ()));
            }
        });
        Supplier<OptimizedModelWrapper> optimizedModelDoor = () -> this.isDoor() ? OptimizedModelWrapper.fromObjModels(objModels) : null;
        this.positionDefinitions.forEach(positionDefinitionName -> positionDefinitionsObject.getPositionDefinition((String)positionDefinitionName, (arg_0, arg_1) -> this.lambda$writeCache$13(objModels, objModelsForPartConditionAndRenderStage, modelYOffset, objModelsForPartConditionAndRenderStageDoorsClosed, (Supplier)optimizedModelDoor, mutableBox, arg_0, arg_1)));
    }

    public void render(Identifier texture, StoredMatrixTransformations storedMatrixTransformations, @Nullable VehicleExtension vehicle, int light, ObjectArrayList<Box> openDoorways) {
        if (vehicle == null || VehicleResource.matchesCondition(vehicle, this.condition, openDoorways.isEmpty())) {
            switch (this.type) {
                case NORMAL: {
                    ObjectIntImmutablePair<QueuedRenderLayer> renderProperties = ModelPropertiesPart.getRenderProperties(this.renderStage, light, vehicle);
                    if (OptimizedRenderer.hasOptimizedRendering()) {
                        MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> this.renderNormal(storedMatrixTransformations, vehicle, renderProperties, openDoorways, light, (GraphicsHolder)graphicsHolder, (Vector3d)offset));
                        break;
                    }
                    MainRenderer.scheduleRender(texture, false, renderProperties.left(), (graphicsHolder, offset) -> this.renderNormal(storedMatrixTransformations, vehicle, renderProperties, openDoorways, light, (GraphicsHolder)graphicsHolder, (Vector3d)offset));
                    break;
                }
                case DISPLAY: {
                    if (vehicle == null) break;
                    if (this.displayOptions.contains(DisplayOption.SEVEN_SEGMENT.toString())) {
                        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/seven_segment.png"), true, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> this.renderDisplay((GraphicsHolder)graphicsHolder, (Vector3d)offset, storedMatrixTransformations, vehicle, true));
                        break;
                    }
                    MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> this.renderDisplay((GraphicsHolder)graphicsHolder, (Vector3d)offset, storedMatrixTransformations, vehicle, false));
                }
            }
        }
    }

    public void getOpenDoorBounds(ObjectArrayList<Box> boxes, double time) {
        if (this.isDoor()) {
            this.partDetailsList.forEach(partDetails -> {
                double x = this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, partDetails.flipped, time) / 16.0;
                double z = this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, partDetails.flipped, time, true) / 16.0;
                Box box = partDetails.box;
                float xOffset = box.getMinXMapped() == box.getMaxXMapped() ? 0.1f : 0.0f;
                float yOffset = box.getMinYMapped() == box.getMaxYMapped() ? 0.1f : 0.0f;
                float zOffset = box.getMinZMapped() == box.getMaxZMapped() ? 0.1f : 0.0f;
                boxes.add(new Box(box.getMinXMapped() - (double)xOffset + x, box.getMinYMapped() - (double)yOffset, box.getMinZMapped() - (double)zOffset + z, box.getMaxXMapped() + (double)xOffset + x, box.getMaxYMapped() + (double)yOffset, box.getMaxZMapped() + (double)zOffset + z));
            });
        }
    }

    void mapDoors(ObjectArraySet<Box> doorways) {
        if (this.isDoor()) {
            this.partDetailsList.forEach(partDetails -> doorways.stream().min(Comparator.comparingDouble(checkDoorway -> ModelPropertiesPart.getClosestDistance(partDetails.box.getMinXMapped(), partDetails.box.getMaxXMapped(), checkDoorway.getMinXMapped(), checkDoorway.getMaxXMapped()) + ModelPropertiesPart.getClosestDistance(partDetails.box.getMinYMapped(), partDetails.box.getMaxYMapped(), checkDoorway.getMinYMapped(), checkDoorway.getMaxYMapped()) + ModelPropertiesPart.getClosestDistance(partDetails.box.getMinZMapped(), partDetails.box.getMaxZMapped(), checkDoorway.getMinZMapped(), checkDoorway.getMaxZMapped()))).ifPresent(closestDoorway -> {
                partDetails.doorway = closestDoorway;
            }));
        }
    }

    private boolean isDoor() {
        return this.doorXMultiplier != 0.0 || this.doorZMultiplier != 0.0;
    }

    private void renderNormal(StoredMatrixTransformations storedMatrixTransformations, @Nullable VehicleExtension vehicle, ObjectIntImmutablePair<QueuedRenderLayer> renderProperties, ObjectArrayList<Box> openDoorways, int light, GraphicsHolder graphicsHolder, Vector3d offset) {
        storedMatrixTransformations.transform(graphicsHolder, offset);
        this.partDetailsList.forEach(partDetails -> {
            boolean canOpenDoors = openDoorways.contains(partDetails.doorway);
            float x = (float)(partDetails.x + (vehicle == null ? 0.0 : this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, partDetails.flipped, canOpenDoors ? vehicle.persistentVehicleData.getDoorValue() : 0.0)));
            float y = (float)partDetails.y;
            float z = (float)(partDetails.z + (vehicle == null ? 0.0 : this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, partDetails.flipped, canOpenDoors ? vehicle.persistentVehicleData.getDoorValue() : 0.0, vehicle.vehicleExtraData.getDoorMultiplier() > 0)));
            if (OptimizedRenderer.hasOptimizedRendering()) {
                if (!openDoorways.isEmpty() && partDetails.optimizedModelDoor != null) {
                    graphicsHolder.push();
                    graphicsHolder.translate(x / 16.0f, y / 16.0f, z / 16.0f);
                    if (partDetails.flipped) {
                        graphicsHolder.rotateYDegrees(180.0f);
                    }
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue(partDetails.optimizedModelDoor, graphicsHolder, light);
                    graphicsHolder.pop();
                }
            } else {
                partDetails.modelParts.forEach(modelPart -> modelPart.render(graphicsHolder, x, y, z, partDetails.flipped ? (float)Math.PI : 0.0f, renderProperties.rightInt(), OverlayTexture.getDefaultUvMapped()));
            }
        });
        graphicsHolder.pop();
    }

    private void renderDisplay(GraphicsHolder graphicsHolder, Vector3d offset, StoredMatrixTransformations storedMatrixTransformations, Vehicle vehicle, boolean isSevenSegment) {
        String[] textSplit = this.formatText(vehicle).split("\\|");
        boolean[] isCjk = new boolean[textSplit.length];
        double tempTotalHeight = 0.0;
        for (int i = 0; i < textSplit.length; ++i) {
            isCjk[i] = IGui.isCjk(textSplit[i]);
            tempTotalHeight += isCjk[i] ? (this.displayCjkSizeRatio <= 0.0 ? 1.0 : this.displayCjkSizeRatio) : 1.0;
        }
        double totalHeight = tempTotalHeight;
        storedMatrixTransformations.transform(graphicsHolder, offset);
        this.displayPartDetailsList.forEach(displayPartDetails -> {
            graphicsHolder.translate(displayPartDetails.x, displayPartDetails.y, displayPartDetails.z);
            if (displayPartDetails.flipped) {
                graphicsHolder.rotateYDegrees(180.0f);
            }
            displayPartDetails.modelDisplayParts.forEach(displayPart -> {
                displayPart.storedMatrixTransformations.transform(graphicsHolder, new Vector3d(0.0, 0.0, 0.0));
                graphicsHolder.translate(isSevenSegment ? 0.0 : this.displayXPadding / 16.0, this.displayYPadding / 16.0, -0.003125f);
                for (int i = 0; i < textSplit.length; ++i) {
                    double lineHeight = isCjk[i] ? (this.displayCjkSizeRatio <= 0.0 ? 1.0 : this.displayCjkSizeRatio) : 1.0;
                    double textHeight = Math.min(((double)displayPart.height - this.displayYPadding * 2.0) * lineHeight / totalHeight, this.displayMaxLineHeight <= 0.0 ? Double.MAX_VALUE : this.displayMaxLineHeight * lineHeight) / 16.0;
                    IGui.HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment(isCjk[i]);
                    if (isSevenSegment) {
                        IDrawing.drawSevenSegment(graphicsHolder, textSplit[i], ((float)displayPart.width - (float)this.displayXPadding * 2.0f) / 16.0f, 0.0f, 0.0f, ((float)displayPart.height - (float)this.displayYPadding * 2.0f) / 16.0f, horizontalAlignment, 0xFF000000 | this.displayColorInt, GraphicsHolder.getDefaultLight());
                    } else {
                        double heightScale = textHeight / 10.0;
                        double textWidth = (double)GraphicsHolder.getTextWidth(textSplit[i]) * heightScale;
                        double availableTextWidth = ((double)displayPart.width - this.displayXPadding * 2.0) / 16.0;
                        double widthScale = Math.min(1.0, textWidth == 0.0 ? 1.0 : availableTextWidth / textWidth);
                        graphicsHolder.push();
                        graphicsHolder.translate(Math.max(0.0f, horizontalAlignment.getOffset(0.0f, (float)(textWidth - availableTextWidth))), 0.0, 0.0);
                        graphicsHolder.scale((float)(widthScale * heightScale), (float)heightScale, 1.0f);
                        graphicsHolder.drawText(textSplit[i], 0, 0, isCjk[i] ? this.displayColorCjkInt : this.displayColorInt, false, GraphicsHolder.getDefaultLight());
                        graphicsHolder.pop();
                    }
                    graphicsHolder.translate(0.0, textHeight, 0.0);
                }
                graphicsHolder.pop();
            });
        });
        graphicsHolder.pop();
    }

    private void addCube(Identifier texture, ObjectArrayList<ModelPartExtension> modelParts, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStage, double x, double y, double z, boolean flipped) {
        modelParts.forEach(modelPart -> Data.put(materialGroupsForPartConditionAndRenderStage, this.condition, this.renderStage, oldValue -> {
            OptimizedModelWrapper.MaterialGroupWrapper materialGroup = oldValue == null ? new OptimizedModelWrapper.MaterialGroupWrapper(this.renderStage.shaderType, texture) : oldValue;
            materialGroup.addCube((ModelPartExtension)modelPart, (x + this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, flipped, 0.0)) / 16.0, y / 16.0, (z + this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, flipped, 0.0, false)) / 16.0, flipped, 0xF000B0);
            return materialGroup;
        }, Object2ObjectOpenHashMap::new));
    }

    private void addObjModelPosition(ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper> objModels, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStage, double x, double y, double z, boolean flipped, double modelYOffset) {
        objModels.forEach(objModel -> Data.put(objModelsForPartConditionAndRenderStage, this.condition, this.renderStage, oldValue -> {
            ObjectArrayList newObjModels = oldValue == null ? new ObjectArrayList() : oldValue;
            objModel.addTransformation(this.renderStage.shaderType, (x + this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, flipped, 0.0)) / 16.0, y / 16.0 - modelYOffset, (z + this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, flipped, 0.0, false)) / 16.0, flipped);
            newObjModels.add(objModel);
            return newObjModels;
        }, Object2ObjectOpenHashMap::new));
    }

    private String formatText(Vehicle vehicle) {
        String newText = switch (this.displayType) {
            case DisplayType.DESTINATION -> vehicle.getIsOnRoute() ? ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisRouteDestination(), ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getNextRouteDestination(), ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getNextStationName(), ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisStationName(), this.displayDefaultText)))) : this.displayDefaultText;
            case DisplayType.ROUTE_NUMBER -> vehicle.getIsOnRoute() ? ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisRouteNumber(), vehicle.vehicleExtraData.getThisRouteDestination(), ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getNextRouteNumber(), vehicle.vehicleExtraData.getNextRouteDestination(), this.displayDefaultText)) : this.displayDefaultText;
            case DisplayType.DEPARTURE_INDEX -> {
                if (vehicle.getIsOnRoute()) {
                    int startLength;
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(vehicle.getDepartureIndex() + 1L));
                    int i = startLength = stringBuilder.length();
                    while ((double)i < this.displayPadZeros) {
                        stringBuilder.insert(0, "0");
                        ++i;
                    }
                    yield stringBuilder.toString();
                }
                yield this.displayDefaultText;
            }
            case DisplayType.NEXT_STATION -> vehicle.vehicleExtraData.getNextStationName();
            default -> "";
        };
        for (String displayOption : this.displayOptions) {
            newText = EnumHelper.valueOf(DisplayOption.NONE, displayOption).format(newText);
        }
        return newText;
    }

    private IGui.HorizontalAlignment getHorizontalAlignment(boolean isCjk) {
        if (isCjk) {
            if (this.displayOptions.contains(DisplayOption.ALIGN_LEFT_CJK.toString())) {
                return IGui.HorizontalAlignment.LEFT;
            }
            if (this.displayOptions.contains(DisplayOption.ALIGN_RIGHT_CJK.toString())) {
                return IGui.HorizontalAlignment.RIGHT;
            }
            if (this.displayOptions.contains(DisplayOption.ALIGN_CENTER_CJK.toString())) {
                return IGui.HorizontalAlignment.CENTER;
            }
        }
        if (this.displayOptions.contains(DisplayOption.ALIGN_LEFT.toString())) {
            return IGui.HorizontalAlignment.LEFT;
        }
        if (this.displayOptions.contains(DisplayOption.ALIGN_RIGHT.toString())) {
            return IGui.HorizontalAlignment.RIGHT;
        }
        return IGui.HorizontalAlignment.CENTER;
    }

    private static ObjectIntImmutablePair<QueuedRenderLayer> getRenderProperties(RenderStage renderStage, int light, @Nullable VehicleExtension vehicle) {
        if (renderStage == RenderStage.ALWAYS_ON_LIGHT) {
            return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.LIGHT_TRANSLUCENT, GraphicsHolder.getDefaultLight());
        }
        if (vehicle != null) {
            if (vehicle.getIsOnRoute()) {
                switch (renderStage) {
                    case LIGHT: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.LIGHT, GraphicsHolder.getDefaultLight());
                    }
                    case INTERIOR: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.INTERIOR, 0xF000B0);
                    }
                    case INTERIOR_TRANSLUCENT: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.INTERIOR_TRANSLUCENT, 0xF000B0);
                    }
                }
            } else if (renderStage == RenderStage.INTERIOR_TRANSLUCENT) {
                return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.EXTERIOR_TRANSLUCENT, light);
            }
        }
        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.EXTERIOR, light);
    }

    private static Box addBox(Box box, double x, double y, double z, boolean flipped) {
        return new Box((double)(flipped ? -1 : 1) * box.getMinXMapped() + x / 16.0, box.getMinYMapped() + y / 16.0, (double)(flipped ? 1 : -1) * box.getMinZMapped() + z / 16.0, (double)(flipped ? -1 : 1) * box.getMaxXMapped() + x / 16.0, box.getMaxYMapped() + y / 16.0, (double)(flipped ? 1 : -1) * box.getMaxZMapped() + z / 16.0);
    }

    private static void iteratePositions(ObjectArrayList<PartPosition> positions, ObjectArrayList<PartPosition> positionsFlipped, PositionCallback positionCallback) {
        positions.forEach(position -> positionCallback.accept(position.getX(), position.getY(), position.getZ(), false));
        positionsFlipped.forEach(position -> positionCallback.accept(-position.getX(), position.getY(), position.getZ(), true));
    }

    private static double getClosestDistance(double a1, double a2, double b1, double b2) {
        return Math.min(Math.min(Math.abs(b1 - a1), Math.abs(b1 - a2)), Math.min(Math.abs(b2 - a1), Math.abs(b2 - a2)));
    }

    private static int parseColor(String colorString, int defaultColor) {
        try {
            return Integer.parseInt(colorString, 16);
        }
        catch (Exception ignored) {
            return defaultColor;
        }
    }

    private static String getOrDefault(String checkText, String defaultText) {
        return ModelPropertiesPart.getOrDefault(checkText, checkText, defaultText);
    }

    private static String getOrDefault(String outputText, String checkText, String defaultText) {
        return checkText.isEmpty() ? defaultText : outputText;
    }

    private /* synthetic */ void lambda$writeCache$13(ObjectArrayList objModels, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStage, double modelYOffset, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStageDoorsClosed, Supplier optimizedModelDoor, MutableBox mutableBox, ObjectArrayList positions, ObjectArrayList positionsFlipped) {
        if (this.type == PartType.NORMAL) {
            ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$writeCache$12(objModels, objModelsForPartConditionAndRenderStage, modelYOffset, objModelsForPartConditionAndRenderStageDoorsClosed, (Supplier)optimizedModelDoor, mutableBox, arg_0, arg_1, arg_2, arg_3));
        }
    }

    private /* synthetic */ void lambda$writeCache$12(ObjectArrayList objModels, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStage, double modelYOffset, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStageDoorsClosed, Supplier optimizedModelDoor, MutableBox mutableBox, double x, double y, double z, boolean flipped) {
        if (!this.isDoor()) {
            this.addObjModelPosition(objModels, objModelsForPartConditionAndRenderStage, x, y, z, flipped, modelYOffset);
        }
        this.addObjModelPosition(objModels, objModelsForPartConditionAndRenderStageDoorsClosed, x, y, z, flipped, modelYOffset);
        this.partDetailsList.add(new PartDetails(new ObjectArrayList<ModelPartExtension>(), (OptimizedModelWrapper)optimizedModelDoor.get(), ModelPropertiesPart.addBox(mutableBox.get(), x, y, z, flipped), x, y, z, flipped));
    }

    @FunctionalInterface
    private static interface PositionCallback {
        public void accept(double var1, double var3, double var5, boolean var7);
    }

    private static class DisplayPartDetails {
        private final ObjectArrayList<ModelDisplayPart> modelDisplayParts;
        private final double x;
        private final double y;
        private final double z;
        private final boolean flipped;

        private DisplayPartDetails(ObjectArrayList<ModelDisplayPart> modelDisplayParts, double x, double y, double z, boolean flipped) {
            this.modelDisplayParts = modelDisplayParts;
            this.x = x / 16.0;
            this.y = y / 16.0;
            this.z = z / 16.0;
            this.flipped = flipped;
        }
    }

    private static class PartDetails {
        private Box doorway;
        private final ObjectArrayList<ModelPartExtension> modelParts;
        private final OptimizedModelWrapper optimizedModelDoor;
        private final Box box;
        private final double x;
        private final double y;
        private final double z;
        private final boolean flipped;

        private PartDetails(ObjectArrayList<ModelPartExtension> modelParts, @Nullable OptimizedModelWrapper optimizedModelDoor, Box box, double x, double y, double z, boolean flipped) {
            this.modelParts = OptimizedRenderer.hasOptimizedRendering() ? new ObjectArrayList() : modelParts;
            this.optimizedModelDoor = optimizedModelDoor;
            this.box = box;
            this.x = x;
            this.y = y;
            this.z = z;
            this.flipped = flipped;
        }
    }
}

