/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.OptimizedRenderer;

public final class OptimizedModelWrapper {
    @Nullable
    final OptimizedModel optimizedModel;

    public static OptimizedModelWrapper fromMaterialGroups(ObjectArrayList<MaterialGroupWrapper> materialGroupList) {
        return new OptimizedModelWrapper(OptimizedRenderer.hasOptimizedRendering() ? OptimizedModel.fromMaterialGroups(materialGroupList.stream().map(materialGroup -> materialGroup.materialGroup).filter(Objects::nonNull).collect(Collectors.toList())) : null);
    }

    public static OptimizedModelWrapper fromObjModels(ObjectArrayList<ObjModelWrapper> objModels) {
        return new OptimizedModelWrapper(OptimizedRenderer.hasOptimizedRendering() ? OptimizedModel.fromObjModels(objModels.stream().map(objModel -> objModel.objModel).filter(Objects::nonNull).collect(Collectors.toList())) : null);
    }

    private OptimizedModelWrapper(@Nullable OptimizedModel optimizedModel) {
        this.optimizedModel = optimizedModel;
    }

    public OptimizedModelWrapper(@Nullable OptimizedModelWrapper optimizedModel1, @Nullable OptimizedModelWrapper optimizedModel2) {
        boolean nonNull2;
        boolean nonNull1 = optimizedModel1 != null && optimizedModel1.optimizedModel != null;
        boolean bl = nonNull2 = optimizedModel2 != null && optimizedModel2.optimizedModel != null;
        this.optimizedModel = OptimizedRenderer.hasOptimizedRendering() ? (nonNull1 && nonNull2 ? new OptimizedModel(optimizedModel1.optimizedModel, optimizedModel2.optimizedModel) : (nonNull1 ? optimizedModel1.optimizedModel : (nonNull2 ? optimizedModel2.optimizedModel : null))) : null;
    }

    public static final class ObjModelWrapper {
        public final OptimizedModel.ObjModel objModel;

        public ObjModelWrapper(OptimizedModel.ObjModel objModel) {
            this.objModel = objModel;
        }

        public void addTransformation(OptimizedModel.ShaderType shaderType, double x, double y, double z, boolean flipped) {
            this.objModel.addTransformation(shaderType, x, y, z, flipped);
        }
    }

    public static final class MaterialGroupWrapper {
        @Nullable
        private final OptimizedModel.MaterialGroup materialGroup;

        @MappedMethod
        public MaterialGroupWrapper(OptimizedModel.ShaderType shaderType, Identifier texture) {
            this.materialGroup = OptimizedRenderer.hasOptimizedRendering() ? new OptimizedModel.MaterialGroup(shaderType, texture) : null;
        }

        @MappedMethod
        public void addCube(ModelPartExtension modelPart, double x, double y, double z, boolean flipped, int light) {
            if (this.materialGroup != null) {
                this.materialGroup.addCube(modelPart, x, y, z, flipped, light);
            }
        }
    }
}

