/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.mtr.core.serializer.JsonReader;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.BlockbenchModel;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.PositionDefinitions;

public interface StoredModelResourceBase {
    default public ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> load(String modelResource, String textureResource, boolean flipTextureV, double modelYOffset) {
        OptimizedModelWrapper[] tempOptimizedModel = new OptimizedModelWrapper[]{null};
        DynamicVehicleModel[] tempDynamicVehicleModel = new DynamicVehicleModel[]{null};
        boolean isBlockbench = modelResource.endsWith(".bbmodel");
        boolean isObj = modelResource.endsWith(".obj");
        Identifier textureId = CustomResourceTools.formatIdentifierWithDefault(textureResource, "png");
        if (isBlockbench) {
            CustomResourceLoader.readResource(CustomResourceTools.formatIdentifier(modelResource, "bbmodel"), jsonElement -> {
                Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroups = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
                tempDynamicVehicleModel[0] = new DynamicVehicleModel(new BlockbenchModel(new JsonReader((JsonElement)jsonElement)), textureId, new ModelProperties(modelYOffset), new PositionDefinitions(), "");
                tempDynamicVehicleModel[0].writeFloorsAndDoorways(new ObjectArraySet<Box>(), new ObjectArraySet<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroups, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>());
                tempOptimizedModel[0] = OptimizedModelWrapper.fromMaterialGroups(materialGroups.get((Object)PartCondition.NORMAL));
            });
            return new ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>(tempOptimizedModel[0], tempDynamicVehicleModel[0]);
        }
        if (isObj) {
            Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModels = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
            Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel> rawModels = new Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel>(OptimizedModel.ObjModel.loadModel(CustomResourceTools.formatIdentifierWithDefault(modelResource, "obj"), textureId, null, true, flipTextureV));
            this.transform((ObjectCollection<OptimizedModel.ObjModel>)rawModels.values());
            DynamicVehicleModel dynamicVehicleModel = new DynamicVehicleModel(rawModels, textureId, new ModelProperties(modelYOffset), new PositionDefinitions(), "");
            dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArraySet<Box>(), new ObjectArraySet<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModels);
            return new ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>(OptimizedModelWrapper.fromObjModels(objModels.get((Object)PartCondition.NORMAL)), dynamicVehicleModel);
        }
        return new ObjectObjectImmutablePair<Object, Object>(null, null);
    }

    default public void render(StoredMatrixTransformations storedMatrixTransformations, int light) {
        OptimizedModelWrapper optimizedModel = this.getOptimizedModel();
        DynamicVehicleModel dynamicVehicleModel = this.getDynamicVehicleModel();
        if (OptimizedRenderer.hasOptimizedRendering()) {
            if (optimizedModel != null) {
                MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue(optimizedModel, (GraphicsHolder)graphicsHolder, light);
                    graphicsHolder.pop();
                });
            }
        } else if (dynamicVehicleModel != null) {
            dynamicVehicleModel.render(storedMatrixTransformations, null, light, new ObjectArrayList<Box>());
        }
    }

    @Nullable
    public OptimizedModelWrapper getOptimizedModel();

    @Nullable
    public DynamicVehicleModel getDynamicVehicleModel();

    default public void transform(ObjectCollection<OptimizedModel.ObjModel> values2) {
    }
}

