/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.generated.resource.VehicleModelSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.resource.BlockbenchModel;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.PositionDefinitions;

public final class VehicleModel
extends VehicleModelSchema {
    @Nullable
    final DynamicVehicleModel model;

    public VehicleModel(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
        ModelProperties[] modelProperties = new ModelProperties[]{null};
        CustomResourceLoader.readResource(CustomResourceTools.formatIdentifier(this.modelPropertiesResource, "json"), jsonElement -> {
            modelProperties[0] = new ModelProperties(new JsonReader((JsonElement)jsonElement));
        });
        PositionDefinitions[] positionDefinitions = new PositionDefinitions[]{null};
        CustomResourceLoader.readResource(CustomResourceTools.formatIdentifier(this.positionDefinitionsResource, "json"), jsonElement -> {
            positionDefinitions[0] = new PositionDefinitions(new JsonReader((JsonElement)jsonElement));
        });
        this.model = this.createModel(modelProperties[0], positionDefinitions[0], this.modelPropertiesResource);
    }

    public VehicleModel(ReaderBase readerBase, @Nullable ModelProperties modelProperties, @Nullable PositionDefinitions positionDefinitions, String id) {
        super(readerBase);
        this.updateData(readerBase);
        this.model = this.createModel(modelProperties, positionDefinitions, id);
    }

    @Nullable
    private DynamicVehicleModel createModel(@Nullable ModelProperties modelProperties, @Nullable PositionDefinitions positionDefinitions, String id) {
        if (modelProperties == null || positionDefinitions == null) {
            return null;
        }
        Identifier textureId = CustomResourceTools.formatIdentifierWithDefault(this.textureResource, "png");
        if (this.modelResource.endsWith(".bbmodel")) {
            BlockbenchModel[] blockbenchModel = new BlockbenchModel[]{null};
            CustomResourceLoader.readResource(CustomResourceTools.formatIdentifier(this.modelResource, "bbmodel"), jsonElement -> {
                blockbenchModel[0] = new BlockbenchModel(new JsonReader((JsonElement)jsonElement));
            });
            return blockbenchModel[0] == null ? null : new DynamicVehicleModel(blockbenchModel[0], textureId, modelProperties, positionDefinitions, id);
        }
        if (this.modelResource.endsWith(".obj")) {
            return new DynamicVehicleModel(new Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel>(OptimizedModel.ObjModel.loadModel(CustomResourceTools.formatIdentifierWithDefault(this.modelResource, "obj"), textureId, null, true, this.flipTextureV)), textureId, modelProperties, positionDefinitions, id);
        }
        return null;
    }
}

